@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.GetAzurePowerShellScriptPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scriptName Name of the deployment script.
 */
public data class GetAzurePowerShellScriptPlainArgs(
    public val resourceGroupName: String,
    public val scriptName: String,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.GetAzurePowerShellScriptPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.GetAzurePowerShellScriptPlainArgs =
        com.pulumi.azurenative.resources.inputs.GetAzurePowerShellScriptPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .scriptName(scriptName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAzurePowerShellScriptPlainArgs].
 */
@PulumiTagMarker
public class GetAzurePowerShellScriptPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var scriptName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jtqagjrnokcemuuc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the deployment script.
     */
    @JvmName("nijxlfdrxvwjfasx")
    public suspend fun scriptName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scriptName = mapped
    }

    internal fun build(): GetAzurePowerShellScriptPlainArgs = GetAzurePowerShellScriptPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        scriptName = scriptName ?: throw PulumiNullFieldException("scriptName"),
    )
}
