@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.GetDeploymentAtScopePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deploymentName The name of the deployment.
 * @property scope The resource scope.
 */
public data class GetDeploymentAtScopePlainArgs(
    public val deploymentName: String,
    public val scope: String,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.GetDeploymentAtScopePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.GetDeploymentAtScopePlainArgs =
        com.pulumi.azurenative.resources.inputs.GetDeploymentAtScopePlainArgs.builder()
            .deploymentName(deploymentName.let({ args0 -> args0 }))
            .scope(scope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDeploymentAtScopePlainArgs].
 */
@PulumiTagMarker
public class GetDeploymentAtScopePlainArgsBuilder internal constructor() {
    private var deploymentName: String? = null

    private var scope: String? = null

    /**
     * @param value The name of the deployment.
     */
    @JvmName("anhgitykmgecohfl")
    public suspend fun deploymentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentName = mapped
    }

    /**
     * @param value The resource scope.
     */
    @JvmName("jraooddvfnfrcnpr")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    internal fun build(): GetDeploymentAtScopePlainArgs = GetDeploymentAtScopePlainArgs(
        deploymentName = deploymentName ?: throw PulumiNullFieldException("deploymentName"),
        scope = scope ?: throw PulumiNullFieldException("scope"),
    )
}
