@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.GetDeploymentStackAtResourceGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deploymentStackName Name of the deployment stack.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDeploymentStackAtResourceGroupPlainArgs(
    public val deploymentStackName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.resources.inputs.GetDeploymentStackAtResourceGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.resources.inputs.GetDeploymentStackAtResourceGroupPlainArgs =
        com.pulumi.azurenative.resources.inputs.GetDeploymentStackAtResourceGroupPlainArgs.builder()
            .deploymentStackName(deploymentStackName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDeploymentStackAtResourceGroupPlainArgs].
 */
@PulumiTagMarker
public class GetDeploymentStackAtResourceGroupPlainArgsBuilder internal constructor() {
    private var deploymentStackName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the deployment stack.
     */
    @JvmName("nggwuctxkqbgbwvx")
    public suspend fun deploymentStackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentStackName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cqapaxknctefxmuf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDeploymentStackAtResourceGroupPlainArgs =
        GetDeploymentStackAtResourceGroupPlainArgs(
            deploymentStackName = deploymentStackName ?: throw PulumiNullFieldException("deploymentStackName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
