@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.KeyVaultReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure Key Vault reference.
 * @property id Azure Key Vault resource id.
 */
public data class KeyVaultReferenceArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.KeyVaultReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.KeyVaultReferenceArgs =
        com.pulumi.azurenative.resources.inputs.KeyVaultReferenceArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultReferenceArgs].
 */
@PulumiTagMarker
public class KeyVaultReferenceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Azure Key Vault resource id.
     */
    @JvmName("wpwphnhhxknaxcya")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Azure Key Vault resource id.
     */
    @JvmName("yusconlrkhmyjbgn")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): KeyVaultReferenceArgs = KeyVaultReferenceArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
