@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.LinkedTemplateArtifactArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a Template Spec artifact containing an embedded Azure Resource Manager template for use as a linked template.
 * @property path A filesystem safe relative path of the artifact.
 * @property template The Azure Resource Manager template.
 */
public data class LinkedTemplateArtifactArgs(
    public val path: Output<String>,
    public val template: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.LinkedTemplateArtifactArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.LinkedTemplateArtifactArgs =
        com.pulumi.azurenative.resources.inputs.LinkedTemplateArtifactArgs.builder()
            .path(path.applyValue({ args0 -> args0 }))
            .template(template.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinkedTemplateArtifactArgs].
 */
@PulumiTagMarker
public class LinkedTemplateArtifactArgsBuilder internal constructor() {
    private var path: Output<String>? = null

    private var template: Output<Any>? = null

    /**
     * @param value A filesystem safe relative path of the artifact.
     */
    @JvmName("ehqdhplgtgelsrot")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The Azure Resource Manager template.
     */
    @JvmName("uywqjqdsvdasuhxk")
    public suspend fun template(`value`: Output<Any>) {
        this.template = value
    }

    /**
     * @param value A filesystem safe relative path of the artifact.
     */
    @JvmName("abolndbsmguwedfj")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value The Azure Resource Manager template.
     */
    @JvmName("rwroxemcspvlkihh")
    public suspend fun template(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.template = mapped
    }

    internal fun build(): LinkedTemplateArtifactArgs = LinkedTemplateArtifactArgs(
        path = path ?: throw PulumiNullFieldException("path"),
        template = template ?: throw PulumiNullFieldException("template"),
    )
}
