@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.ManagedServiceIdentityArgs.builder
import com.pulumi.azurenative.resources.kotlin.enums.ManagedServiceIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Managed identity generic object.
 * @property type Type of the managed identity.
 * @property userAssignedIdentities The list of user-assigned managed identities associated with the resource. Key is the Azure resource Id of the managed identity.
 */
public data class ManagedServiceIdentityArgs(
    public val type: Output<Either<String, ManagedServiceIdentityType>>? = null,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.ManagedServiceIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.ManagedServiceIdentityArgs =
        com.pulumi.azurenative.resources.inputs.ManagedServiceIdentityArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedServiceIdentityArgs].
 */
@PulumiTagMarker
public class ManagedServiceIdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, ManagedServiceIdentityType>>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value Type of the managed identity.
     */
    @JvmName("qpbjgvshgwduegyw")
    public suspend fun type(`value`: Output<Either<String, ManagedServiceIdentityType>>) {
        this.type = value
    }

    /**
     * @param value The list of user-assigned managed identities associated with the resource. Key is the Azure resource Id of the managed identity.
     */
    @JvmName("qhljsamblitshqft")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("nonbbmlhbnpnuqyj")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values The list of user-assigned managed identities associated with the resource. Key is the Azure resource Id of the managed identity.
     */
    @JvmName("cbkvlybnhajoqhxe")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value Type of the managed identity.
     */
    @JvmName("hxqbbjhasesudwbc")
    public suspend fun type(`value`: Either<String, ManagedServiceIdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of the managed identity.
     */
    @JvmName("kiytwljgemrkyfio")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedServiceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of the managed identity.
     */
    @JvmName("nosmlblvpxubbvyq")
    public fun type(`value`: ManagedServiceIdentityType) {
        val toBeMapped = Either.ofRight<String, ManagedServiceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The list of user-assigned managed identities associated with the resource. Key is the Azure resource Id of the managed identity.
     */
    @JvmName("glnbklmeioktbbxm")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The list of user-assigned managed identities associated with the resource. Key is the Azure resource Id of the managed identity.
     */
    @JvmName("diwqcoulvwgwselx")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): ManagedServiceIdentityArgs = ManagedServiceIdentityArgs(
        type = type,
        userAssignedIdentities = userAssignedIdentities,
    )
}
