@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.OnErrorDeploymentArgs.builder
import com.pulumi.azurenative.resources.kotlin.enums.OnErrorDeploymentType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Deployment on error behavior.
 * @property deploymentName The deployment to be used on error case.
 * @property type The deployment on error behavior type. Possible values are LastSuccessful and SpecificDeployment.
 */
public data class OnErrorDeploymentArgs(
    public val deploymentName: Output<String>? = null,
    public val type: Output<OnErrorDeploymentType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.OnErrorDeploymentArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.OnErrorDeploymentArgs =
        com.pulumi.azurenative.resources.inputs.OnErrorDeploymentArgs.builder()
            .deploymentName(deploymentName?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [OnErrorDeploymentArgs].
 */
@PulumiTagMarker
public class OnErrorDeploymentArgsBuilder internal constructor() {
    private var deploymentName: Output<String>? = null

    private var type: Output<OnErrorDeploymentType>? = null

    /**
     * @param value The deployment to be used on error case.
     */
    @JvmName("tlbtvjjecqyeaplw")
    public suspend fun deploymentName(`value`: Output<String>) {
        this.deploymentName = value
    }

    /**
     * @param value The deployment on error behavior type. Possible values are LastSuccessful and SpecificDeployment.
     */
    @JvmName("jsrpnjsofeaccrlp")
    public suspend fun type(`value`: Output<OnErrorDeploymentType>) {
        this.type = value
    }

    /**
     * @param value The deployment to be used on error case.
     */
    @JvmName("ajmroeqmsaxxixgy")
    public suspend fun deploymentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentName = mapped
    }

    /**
     * @param value The deployment on error behavior type. Possible values are LastSuccessful and SpecificDeployment.
     */
    @JvmName("ltyofphespeahhwa")
    public suspend fun type(`value`: OnErrorDeploymentType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): OnErrorDeploymentArgs = OnErrorDeploymentArgs(
        deploymentName = deploymentName,
        type = type,
    )
}
