@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The alias type.
 * @property defaultMetadata The default alias path metadata. Applies to the default path and to any alias path that doesn't have metadata
 * @property defaultPath The default path for an alias.
 * @property defaultPattern The default pattern for an alias.
 * @property name The alias name.
 * @property paths The paths for an alias.
 * @property type The type of the alias.
 */
public data class AliasResponse(
    public val defaultMetadata: AliasPathMetadataResponse,
    public val defaultPath: String? = null,
    public val defaultPattern: AliasPatternResponse? = null,
    public val name: String? = null,
    public val paths: List<AliasPathResponse>? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.AliasResponse):
            AliasResponse = AliasResponse(
            defaultMetadata = javaType.defaultMetadata().let({ args0 ->
                com.pulumi.azurenative.resources.kotlin.outputs.AliasPathMetadataResponse.Companion.toKotlin(args0)
            }),
            defaultPath = javaType.defaultPath().map({ args0 -> args0 }).orElse(null),
            defaultPattern = javaType.defaultPattern().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.AliasPatternResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            paths = javaType.paths().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.AliasPathResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
