@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).
 * @property additionalInfo The error additional info.
 * @property code The error code.
 * @property details The error details.
 * @property error The error object.
 * @property message The error message.
 * @property target The error target.
 */
public data class ErrorResponseResponse(
    public val additionalInfo: List<ErrorAdditionalInfoResponse>? = null,
    public val code: String? = null,
    public val details: List<ErrorResponseResponse>? = null,
    public val error: ErrorDetailResponse? = null,
    public val message: String? = null,
    public val target: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.ErrorResponseResponse):
            ErrorResponseResponse = ErrorResponseResponse(
            additionalInfo = javaType.additionalInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.ErrorAdditionalInfoResponse.Companion.toKotlin(args0)
                })
            }),
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.ErrorResponseResponse.Companion.toKotlin(args0)
                })
            }),
            error = javaType.error().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.ErrorDetailResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
        )
    }
}
