@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Resource type managed by the resource provider.
 * @property aliases The aliases that are supported by this resource type.
 * @property apiProfiles The API profiles for the resource provider.
 * @property apiVersions The API version.
 * @property capabilities The additional capabilities offered by this resource type.
 * @property defaultApiVersion The default API version.
 * @property locationMappings The location mappings that are supported by this resource type.
 * @property locations The collection of locations where this resource type can be created.
 * @property properties The properties.
 * @property resourceType The resource type.
 * @property zoneMappings
 */
public data class ProviderResourceTypeResponse(
    public val aliases: List<AliasResponse>? = null,
    public val apiProfiles: List<ApiProfileResponse>,
    public val apiVersions: List<String>? = null,
    public val capabilities: String? = null,
    public val defaultApiVersion: String,
    public val locationMappings: List<ProviderExtendedLocationResponse>? = null,
    public val locations: List<String>? = null,
    public val properties: Map<String, String>? = null,
    public val resourceType: String? = null,
    public val zoneMappings: List<ZoneMappingResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.ProviderResourceTypeResponse):
            ProviderResourceTypeResponse = ProviderResourceTypeResponse(
            aliases = javaType.aliases().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.AliasResponse.Companion.toKotlin(args0)
                })
            }),
            apiProfiles = javaType.apiProfiles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.ApiProfileResponse.Companion.toKotlin(args0)
                })
            }),
            apiVersions = javaType.apiVersions().map({ args0 -> args0 }),
            capabilities = javaType.capabilities().map({ args0 -> args0 }).orElse(null),
            defaultApiVersion = javaType.defaultApiVersion(),
            locationMappings = javaType.locationMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.ProviderExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }),
            locations = javaType.locations().map({ args0 -> args0 }),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            resourceType = javaType.resourceType().map({ args0 -> args0 }).orElse(null),
            zoneMappings = javaType.zoneMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.ZoneMappingResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
