@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Resource provider information.
 * @property id The provider ID.
 * @property namespace The namespace of the resource provider.
 * @property providerAuthorizationConsentState The provider authorization consent state.
 * @property registrationPolicy The registration policy of the resource provider.
 * @property registrationState The registration state of the resource provider.
 * @property resourceTypes The collection of provider resource types.
 */
public data class ProviderResponse(
    public val id: String,
    public val namespace: String? = null,
    public val providerAuthorizationConsentState: String? = null,
    public val registrationPolicy: String,
    public val registrationState: String,
    public val resourceTypes: List<ProviderResourceTypeResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.ProviderResponse):
            ProviderResponse = ProviderResponse(
            id = javaType.id(),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            providerAuthorizationConsentState = javaType.providerAuthorizationConsentState().map({ args0 ->
                args0
            }).orElse(null),
            registrationPolicy = javaType.registrationPolicy(),
            registrationState = javaType.registrationState(),
            resourceTypes = javaType.resourceTypes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.ProviderResourceTypeResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
