@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * High-level information about a Template Spec version.
 * @property description Template Spec version description.
 * @property timeCreated The timestamp of when the version was created.
 * @property timeModified The timestamp of when the version was last modified.
 */
public data class TemplateSpecVersionInfoResponse(
    public val description: String,
    public val timeCreated: String,
    public val timeModified: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.TemplateSpecVersionInfoResponse):
            TemplateSpecVersionInfoResponse = TemplateSpecVersionInfoResponse(
            description = javaType.description(),
            timeCreated = javaType.timeCreated(),
            timeModified = javaType.timeModified(),
        )
    }
}
