@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.saas.kotlin.inputs

import com.pulumi.azurenative.saas.inputs.SaasCreationPropertiesArgs.builder
import com.pulumi.azurenative.saas.kotlin.enums.PaymentChannelType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * properties for creation saas
 * @property autoRenew Whether the SaaS subscription will auto renew upon term end.
 * @property offerId The offer id.
 * @property paymentChannelMetadata The metadata about the SaaS subscription such as the AzureSubscriptionId and ResourceUri.
 * @property paymentChannelType The Payment channel for the SaasSubscription.
 * @property publisherId The publisher id.
 * @property publisherTestEnvironment The environment in the publisher side for this resource.
 * @property quantity The seat count.
 * @property saasResourceName The SaaS resource name.
 * @property saasSessionId The saas session id used for dev service migration request.
 * @property saasSubscriptionId The saas subscription id used for tenant to subscription level migration request.
 * @property skuId The plan id.
 * @property termId The current Term id.
 */
public data class SaasCreationPropertiesArgs(
    public val autoRenew: Output<Boolean>? = null,
    public val offerId: Output<String>? = null,
    public val paymentChannelMetadata: Output<Map<String, String>>? = null,
    public val paymentChannelType: Output<Either<String, PaymentChannelType>>? = null,
    public val publisherId: Output<String>? = null,
    public val publisherTestEnvironment: Output<String>? = null,
    public val quantity: Output<Double>? = null,
    public val saasResourceName: Output<String>? = null,
    public val saasSessionId: Output<String>? = null,
    public val saasSubscriptionId: Output<String>? = null,
    public val skuId: Output<String>? = null,
    public val termId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.saas.inputs.SaasCreationPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.saas.inputs.SaasCreationPropertiesArgs =
        com.pulumi.azurenative.saas.inputs.SaasCreationPropertiesArgs.builder()
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .offerId(offerId?.applyValue({ args0 -> args0 }))
            .paymentChannelMetadata(
                paymentChannelMetadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .paymentChannelType(
                paymentChannelType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .publisherId(publisherId?.applyValue({ args0 -> args0 }))
            .publisherTestEnvironment(publisherTestEnvironment?.applyValue({ args0 -> args0 }))
            .quantity(quantity?.applyValue({ args0 -> args0 }))
            .saasResourceName(saasResourceName?.applyValue({ args0 -> args0 }))
            .saasSessionId(saasSessionId?.applyValue({ args0 -> args0 }))
            .saasSubscriptionId(saasSubscriptionId?.applyValue({ args0 -> args0 }))
            .skuId(skuId?.applyValue({ args0 -> args0 }))
            .termId(termId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SaasCreationPropertiesArgs].
 */
@PulumiTagMarker
public class SaasCreationPropertiesArgsBuilder internal constructor() {
    private var autoRenew: Output<Boolean>? = null

    private var offerId: Output<String>? = null

    private var paymentChannelMetadata: Output<Map<String, String>>? = null

    private var paymentChannelType: Output<Either<String, PaymentChannelType>>? = null

    private var publisherId: Output<String>? = null

    private var publisherTestEnvironment: Output<String>? = null

    private var quantity: Output<Double>? = null

    private var saasResourceName: Output<String>? = null

    private var saasSessionId: Output<String>? = null

    private var saasSubscriptionId: Output<String>? = null

    private var skuId: Output<String>? = null

    private var termId: Output<String>? = null

    /**
     * @param value Whether the SaaS subscription will auto renew upon term end.
     */
    @JvmName("grgcbcshktxtpdwi")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value The offer id.
     */
    @JvmName("tvhmfekjermvkdjd")
    public suspend fun offerId(`value`: Output<String>) {
        this.offerId = value
    }

    /**
     * @param value The metadata about the SaaS subscription such as the AzureSubscriptionId and ResourceUri.
     */
    @JvmName("wmmyjrxcrfjqcxfw")
    public suspend fun paymentChannelMetadata(`value`: Output<Map<String, String>>) {
        this.paymentChannelMetadata = value
    }

    /**
     * @param value The Payment channel for the SaasSubscription.
     */
    @JvmName("oadrodfdrxxjhjfb")
    public suspend fun paymentChannelType(`value`: Output<Either<String, PaymentChannelType>>) {
        this.paymentChannelType = value
    }

    /**
     * @param value The publisher id.
     */
    @JvmName("slqgattisavtnlcx")
    public suspend fun publisherId(`value`: Output<String>) {
        this.publisherId = value
    }

    /**
     * @param value The environment in the publisher side for this resource.
     */
    @JvmName("llpeprhsettobsol")
    public suspend fun publisherTestEnvironment(`value`: Output<String>) {
        this.publisherTestEnvironment = value
    }

    /**
     * @param value The seat count.
     */
    @JvmName("wdccvljdelinslrl")
    public suspend fun quantity(`value`: Output<Double>) {
        this.quantity = value
    }

    /**
     * @param value The SaaS resource name.
     */
    @JvmName("fxuouslhskwbuwri")
    public suspend fun saasResourceName(`value`: Output<String>) {
        this.saasResourceName = value
    }

    /**
     * @param value The saas session id used for dev service migration request.
     */
    @JvmName("pmnqfthemymfddjp")
    public suspend fun saasSessionId(`value`: Output<String>) {
        this.saasSessionId = value
    }

    /**
     * @param value The saas subscription id used for tenant to subscription level migration request.
     */
    @JvmName("ovqwsbrhugptiryj")
    public suspend fun saasSubscriptionId(`value`: Output<String>) {
        this.saasSubscriptionId = value
    }

    /**
     * @param value The plan id.
     */
    @JvmName("jveufcdpqcvjixxv")
    public suspend fun skuId(`value`: Output<String>) {
        this.skuId = value
    }

    /**
     * @param value The current Term id.
     */
    @JvmName("uuaesqaiwwomrrvi")
    public suspend fun termId(`value`: Output<String>) {
        this.termId = value
    }

    /**
     * @param value Whether the SaaS subscription will auto renew upon term end.
     */
    @JvmName("dygcxusynilbefjq")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value The offer id.
     */
    @JvmName("qyvovidsojoisbic")
    public suspend fun offerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offerId = mapped
    }

    /**
     * @param value The metadata about the SaaS subscription such as the AzureSubscriptionId and ResourceUri.
     */
    @JvmName("eyqxmhlltayhwups")
    public suspend fun paymentChannelMetadata(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentChannelMetadata = mapped
    }

    /**
     * @param values The metadata about the SaaS subscription such as the AzureSubscriptionId and ResourceUri.
     */
    @JvmName("gehjharekhgypwqk")
    public fun paymentChannelMetadata(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paymentChannelMetadata = mapped
    }

    /**
     * @param value The Payment channel for the SaasSubscription.
     */
    @JvmName("hqrovkaaraomdjql")
    public suspend fun paymentChannelType(`value`: Either<String, PaymentChannelType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentChannelType = mapped
    }

    /**
     * @param value The Payment channel for the SaasSubscription.
     */
    @JvmName("cbtleedjobktkwfo")
    public fun paymentChannelType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PaymentChannelType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paymentChannelType = mapped
    }

    /**
     * @param value The Payment channel for the SaasSubscription.
     */
    @JvmName("sryromcjolauldoo")
    public fun paymentChannelType(`value`: PaymentChannelType) {
        val toBeMapped = Either.ofRight<String, PaymentChannelType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paymentChannelType = mapped
    }

    /**
     * @param value The publisher id.
     */
    @JvmName("wkckhlmxqtvtipqq")
    public suspend fun publisherId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisherId = mapped
    }

    /**
     * @param value The environment in the publisher side for this resource.
     */
    @JvmName("nfehflriehfjcypr")
    public suspend fun publisherTestEnvironment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisherTestEnvironment = mapped
    }

    /**
     * @param value The seat count.
     */
    @JvmName("nvxvtbvepiecpvke")
    public suspend fun quantity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quantity = mapped
    }

    /**
     * @param value The SaaS resource name.
     */
    @JvmName("ewoyjtevfhnybuch")
    public suspend fun saasResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.saasResourceName = mapped
    }

    /**
     * @param value The saas session id used for dev service migration request.
     */
    @JvmName("decgpbpjubspxnym")
    public suspend fun saasSessionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.saasSessionId = mapped
    }

    /**
     * @param value The saas subscription id used for tenant to subscription level migration request.
     */
    @JvmName("wqpxmoipbiiciiax")
    public suspend fun saasSubscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.saasSubscriptionId = mapped
    }

    /**
     * @param value The plan id.
     */
    @JvmName("tjkbyasikjtancvk")
    public suspend fun skuId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skuId = mapped
    }

    /**
     * @param value The current Term id.
     */
    @JvmName("gotbnioafipsxpdn")
    public suspend fun termId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.termId = mapped
    }

    internal fun build(): SaasCreationPropertiesArgs = SaasCreationPropertiesArgs(
        autoRenew = autoRenew,
        offerId = offerId,
        paymentChannelMetadata = paymentChannelMetadata,
        paymentChannelType = paymentChannelType,
        publisherId = publisherId,
        publisherTestEnvironment = publisherTestEnvironment,
        quantity = quantity,
        saasResourceName = saasResourceName,
        saasSessionId = saasSessionId,
        saasSubscriptionId = saasSubscriptionId,
        skuId = skuId,
        termId = termId,
    )
}
