@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin

import com.pulumi.azurenative.scheduler.kotlin.outputs.JobPropertiesResponse
import com.pulumi.azurenative.scheduler.kotlin.outputs.JobPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Job].
 */
@PulumiTagMarker
public class JobResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobArgs = JobArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobArgsBuilder.() -> Unit) {
        val builder = JobArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Job {
        val builtJavaResource = com.pulumi.azurenative.scheduler.Job(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Job(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2016-03-01. Prior API version in Azure Native 1.x: 2016-03-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scheduler:Job myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}/jobs/{jobName}
 * ```
 */
public class Job internal constructor(
    override val javaResource: com.pulumi.azurenative.scheduler.Job,
) : KotlinCustomResource(javaResource, JobMapper) {
    /**
     * Gets the job resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the job properties.
     */
    public val properties: Output<JobPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Gets the job resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object JobMapper : ResourceMapper<Job> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.scheduler.Job::class == javaResource::class

    override fun map(javaResource: Resource): Job = Job(
        javaResource as
            com.pulumi.azurenative.scheduler.Job,
    )
}

/**
 * @see [Job].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Job].
 */
public suspend fun job(name: String, block: suspend JobResourceBuilder.() -> Unit): Job {
    val builder = JobResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Job].
 * @param name The _unique_ name of the resulting resource.
 */
public fun job(name: String): Job {
    val builder = JobResourceBuilder()
    builder.name(name)
    return builder.build()
}
