@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets the job action type.
 */
public enum class JobActionType(
    public val javaValue: com.pulumi.azurenative.scheduler.enums.JobActionType,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.enums.JobActionType> {
    Http(com.pulumi.azurenative.scheduler.enums.JobActionType.Http),
    Https(com.pulumi.azurenative.scheduler.enums.JobActionType.Https),
    StorageQueue(com.pulumi.azurenative.scheduler.enums.JobActionType.StorageQueue),
    ServiceBusQueue(com.pulumi.azurenative.scheduler.enums.JobActionType.ServiceBusQueue),
    ServiceBusTopic(com.pulumi.azurenative.scheduler.enums.JobActionType.ServiceBusTopic),
    ;

    override fun toJava(): com.pulumi.azurenative.scheduler.enums.JobActionType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scheduler.enums.JobActionType):
            JobActionType = JobActionType.values().first { it.javaValue == javaType }
    }
}
