@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
 */
public enum class RecurrenceFrequency(
    public val javaValue: com.pulumi.azurenative.scheduler.enums.RecurrenceFrequency,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.enums.RecurrenceFrequency> {
    Minute(com.pulumi.azurenative.scheduler.enums.RecurrenceFrequency.Minute),
    Hour(com.pulumi.azurenative.scheduler.enums.RecurrenceFrequency.Hour),
    Day(com.pulumi.azurenative.scheduler.enums.RecurrenceFrequency.Day),
    Week(com.pulumi.azurenative.scheduler.enums.RecurrenceFrequency.Week),
    Month(com.pulumi.azurenative.scheduler.enums.RecurrenceFrequency.Month),
    ;

    override fun toJava(): com.pulumi.azurenative.scheduler.enums.RecurrenceFrequency = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scheduler.enums.RecurrenceFrequency):
            RecurrenceFrequency = RecurrenceFrequency.values().first { it.javaValue == javaType }
    }
}
