@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.inputs

import com.pulumi.azurenative.scheduler.inputs.HttpRequestArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property authentication Gets or sets the authentication method of the request.
 * @property body Gets or sets the request body.
 * @property headers Gets or sets the headers.
 * @property method Gets or sets the method of the request.
 * @property uri Gets or sets the URI of the request.
 */
public data class HttpRequestArgs(
    public val authentication: Output<Any>? = null,
    public val body: Output<String>? = null,
    public val headers: Output<Map<String, String>>? = null,
    public val method: Output<String>? = null,
    public val uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.inputs.HttpRequestArgs> {
    override fun toJava(): com.pulumi.azurenative.scheduler.inputs.HttpRequestArgs =
        com.pulumi.azurenative.scheduler.inputs.HttpRequestArgs.builder()
            .authentication(authentication?.applyValue({ args0 -> args0 }))
            .body(body?.applyValue({ args0 -> args0 }))
            .headers(headers?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .method(method?.applyValue({ args0 -> args0 }))
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HttpRequestArgs].
 */
@PulumiTagMarker
public class HttpRequestArgsBuilder internal constructor() {
    private var authentication: Output<Any>? = null

    private var body: Output<String>? = null

    private var headers: Output<Map<String, String>>? = null

    private var method: Output<String>? = null

    private var uri: Output<String>? = null

    /**
     * @param value Gets or sets the authentication method of the request.
     */
    @JvmName("iysyaetyxigmurcn")
    public suspend fun authentication(`value`: Output<Any>) {
        this.authentication = value
    }

    /**
     * @param value Gets or sets the request body.
     */
    @JvmName("yvqmsruckpjcmiid")
    public suspend fun body(`value`: Output<String>) {
        this.body = value
    }

    /**
     * @param value Gets or sets the headers.
     */
    @JvmName("kkpyrafncyanhexh")
    public suspend fun headers(`value`: Output<Map<String, String>>) {
        this.headers = value
    }

    /**
     * @param value Gets or sets the method of the request.
     */
    @JvmName("ofmrmhvdmowdjesg")
    public suspend fun method(`value`: Output<String>) {
        this.method = value
    }

    /**
     * @param value Gets or sets the URI of the request.
     */
    @JvmName("setmbwegfxdcfnyl")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value Gets or sets the authentication method of the request.
     */
    @JvmName("vatmmiphwxbcxvao")
    public suspend fun authentication(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param value Gets or sets the request body.
     */
    @JvmName("xjdvopmifvuehncm")
    public suspend fun body(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param value Gets or sets the headers.
     */
    @JvmName("lqouoqmvoydkbtib")
    public suspend fun headers(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param values Gets or sets the headers.
     */
    @JvmName("ralgffluptqrigov")
    public fun headers(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Gets or sets the method of the request.
     */
    @JvmName("chebsxhjftnccoda")
    public suspend fun method(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value Gets or sets the URI of the request.
     */
    @JvmName("bspdgstohlsbumec")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): HttpRequestArgs = HttpRequestArgs(
        authentication = authentication,
        body = body,
        headers = headers,
        method = method,
        uri = uri,
    )
}
