@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.inputs

import com.pulumi.azurenative.scheduler.inputs.JobCollectionQuotaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property maxJobCount Gets or set the maximum job count.
 * @property maxJobOccurrence Gets or sets the maximum job occurrence.
 * @property maxRecurrence Gets or set the maximum recurrence.
 */
public data class JobCollectionQuotaArgs(
    public val maxJobCount: Output<Int>? = null,
    public val maxJobOccurrence: Output<Int>? = null,
    public val maxRecurrence: Output<JobMaxRecurrenceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.inputs.JobCollectionQuotaArgs> {
    override fun toJava(): com.pulumi.azurenative.scheduler.inputs.JobCollectionQuotaArgs =
        com.pulumi.azurenative.scheduler.inputs.JobCollectionQuotaArgs.builder()
            .maxJobCount(maxJobCount?.applyValue({ args0 -> args0 }))
            .maxJobOccurrence(maxJobOccurrence?.applyValue({ args0 -> args0 }))
            .maxRecurrence(maxRecurrence?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [JobCollectionQuotaArgs].
 */
@PulumiTagMarker
public class JobCollectionQuotaArgsBuilder internal constructor() {
    private var maxJobCount: Output<Int>? = null

    private var maxJobOccurrence: Output<Int>? = null

    private var maxRecurrence: Output<JobMaxRecurrenceArgs>? = null

    /**
     * @param value Gets or set the maximum job count.
     */
    @JvmName("eqomimpjbpvvbksc")
    public suspend fun maxJobCount(`value`: Output<Int>) {
        this.maxJobCount = value
    }

    /**
     * @param value Gets or sets the maximum job occurrence.
     */
    @JvmName("dddunrosovlmpicd")
    public suspend fun maxJobOccurrence(`value`: Output<Int>) {
        this.maxJobOccurrence = value
    }

    /**
     * @param value Gets or set the maximum recurrence.
     */
    @JvmName("iwptdsqagiqvwsdl")
    public suspend fun maxRecurrence(`value`: Output<JobMaxRecurrenceArgs>) {
        this.maxRecurrence = value
    }

    /**
     * @param value Gets or set the maximum job count.
     */
    @JvmName("gruqgjphtopirksn")
    public suspend fun maxJobCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxJobCount = mapped
    }

    /**
     * @param value Gets or sets the maximum job occurrence.
     */
    @JvmName("eacjoyvjxhupccfs")
    public suspend fun maxJobOccurrence(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxJobOccurrence = mapped
    }

    /**
     * @param value Gets or set the maximum recurrence.
     */
    @JvmName("gaslsbltuuackowh")
    public suspend fun maxRecurrence(`value`: JobMaxRecurrenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRecurrence = mapped
    }

    /**
     * @param argument Gets or set the maximum recurrence.
     */
    @JvmName("wuodshygelpxylkh")
    public suspend fun maxRecurrence(argument: suspend JobMaxRecurrenceArgsBuilder.() -> Unit) {
        val toBeMapped = JobMaxRecurrenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.maxRecurrence = mapped
    }

    internal fun build(): JobCollectionQuotaArgs = JobCollectionQuotaArgs(
        maxJobCount = maxJobCount,
        maxJobOccurrence = maxJobOccurrence,
        maxRecurrence = maxRecurrence,
    )
}
