@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.inputs

import com.pulumi.azurenative.scheduler.inputs.JobPropertiesArgs.builder
import com.pulumi.azurenative.scheduler.kotlin.enums.JobState
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property action Gets or sets the job action.
 * @property recurrence Gets or sets the job recurrence.
 * @property startTime Gets or sets the job start time.
 * @property state Gets or set the job state.
 */
public data class JobPropertiesArgs(
    public val action: Output<JobActionArgs>? = null,
    public val recurrence: Output<JobRecurrenceArgs>? = null,
    public val startTime: Output<String>? = null,
    public val state: Output<JobState>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.inputs.JobPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.scheduler.inputs.JobPropertiesArgs =
        com.pulumi.azurenative.scheduler.inputs.JobPropertiesArgs.builder()
            .action(action?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .recurrence(recurrence?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [JobPropertiesArgs].
 */
@PulumiTagMarker
public class JobPropertiesArgsBuilder internal constructor() {
    private var action: Output<JobActionArgs>? = null

    private var recurrence: Output<JobRecurrenceArgs>? = null

    private var startTime: Output<String>? = null

    private var state: Output<JobState>? = null

    /**
     * @param value Gets or sets the job action.
     */
    @JvmName("mewmgnpcnipktgsb")
    public suspend fun action(`value`: Output<JobActionArgs>) {
        this.action = value
    }

    /**
     * @param value Gets or sets the job recurrence.
     */
    @JvmName("wspkfdeuvpuiuvcg")
    public suspend fun recurrence(`value`: Output<JobRecurrenceArgs>) {
        this.recurrence = value
    }

    /**
     * @param value Gets or sets the job start time.
     */
    @JvmName("ygdncqvdkdmhidkf")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Gets or set the job state.
     */
    @JvmName("tjvfedbvvqnyoybc")
    public suspend fun state(`value`: Output<JobState>) {
        this.state = value
    }

    /**
     * @param value Gets or sets the job action.
     */
    @JvmName("voawkbdychlwjuim")
    public suspend fun action(`value`: JobActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument Gets or sets the job action.
     */
    @JvmName("jtqnqesuskhfaddw")
    public suspend fun action(argument: suspend JobActionArgsBuilder.() -> Unit) {
        val toBeMapped = JobActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value Gets or sets the job recurrence.
     */
    @JvmName("dtqkpnhoabywsbvw")
    public suspend fun recurrence(`value`: JobRecurrenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrence = mapped
    }

    /**
     * @param argument Gets or sets the job recurrence.
     */
    @JvmName("vvuhnrempkyimgko")
    public suspend fun recurrence(argument: suspend JobRecurrenceArgsBuilder.() -> Unit) {
        val toBeMapped = JobRecurrenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.recurrence = mapped
    }

    /**
     * @param value Gets or sets the job start time.
     */
    @JvmName("nuhxruafxcodepbj")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value Gets or set the job state.
     */
    @JvmName("aogsiiemvjsmyrok")
    public suspend fun state(`value`: JobState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): JobPropertiesArgs = JobPropertiesArgs(
        action = action,
        recurrence = recurrence,
        startTime = startTime,
        state = state,
    )
}
