@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.inputs

import com.pulumi.azurenative.scheduler.inputs.JobRecurrenceScheduleMonthlyOccurrenceArgs.builder
import com.pulumi.azurenative.scheduler.kotlin.enums.JobScheduleDay
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property day Gets or sets the day. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
 * @property occurrence Gets or sets the occurrence. Must be between -5 and 5.
 */
public data class JobRecurrenceScheduleMonthlyOccurrenceArgs(
    public val day: Output<JobScheduleDay>? = null,
    public val occurrence: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.scheduler.inputs.JobRecurrenceScheduleMonthlyOccurrenceArgs> {
    override fun toJava():
        com.pulumi.azurenative.scheduler.inputs.JobRecurrenceScheduleMonthlyOccurrenceArgs =
        com.pulumi.azurenative.scheduler.inputs.JobRecurrenceScheduleMonthlyOccurrenceArgs.builder()
            .day(day?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .occurrence(occurrence?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobRecurrenceScheduleMonthlyOccurrenceArgs].
 */
@PulumiTagMarker
public class JobRecurrenceScheduleMonthlyOccurrenceArgsBuilder internal constructor() {
    private var day: Output<JobScheduleDay>? = null

    private var occurrence: Output<Int>? = null

    /**
     * @param value Gets or sets the day. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
     */
    @JvmName("cssphjqplpomkggv")
    public suspend fun day(`value`: Output<JobScheduleDay>) {
        this.day = value
    }

    /**
     * @param value Gets or sets the occurrence. Must be between -5 and 5.
     */
    @JvmName("trtdremcimxfhmku")
    public suspend fun occurrence(`value`: Output<Int>) {
        this.occurrence = value
    }

    /**
     * @param value Gets or sets the day. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
     */
    @JvmName("ljbsrdegknqilkfl")
    public suspend fun day(`value`: JobScheduleDay?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.day = mapped
    }

    /**
     * @param value Gets or sets the occurrence. Must be between -5 and 5.
     */
    @JvmName("pdytoqjlxnhufkdk")
    public suspend fun occurrence(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.occurrence = mapped
    }

    internal fun build(): JobRecurrenceScheduleMonthlyOccurrenceArgs =
        JobRecurrenceScheduleMonthlyOccurrenceArgs(
            day = day,
            occurrence = occurrence,
        )
}
