@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.inputs

import com.pulumi.azurenative.scheduler.inputs.ServiceBusQueueMessageArgs.builder
import com.pulumi.azurenative.scheduler.kotlin.enums.ServiceBusTransportType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property authentication Gets or sets the Service Bus authentication.
 * @property brokeredMessageProperties Gets or sets the brokered message properties.
 * @property customMessageProperties Gets or sets the custom message properties.
 * @property message Gets or sets the message.
 * @property namespace Gets or sets the namespace.
 * @property queueName Gets or sets the queue name.
 * @property transportType Gets or sets the transport type.
 */
public data class ServiceBusQueueMessageArgs(
    public val authentication: Output<ServiceBusAuthenticationArgs>? = null,
    public val brokeredMessageProperties: Output<ServiceBusBrokeredMessagePropertiesArgs>? = null,
    public val customMessageProperties: Output<Map<String, String>>? = null,
    public val message: Output<String>? = null,
    public val namespace: Output<String>? = null,
    public val queueName: Output<String>? = null,
    public val transportType: Output<ServiceBusTransportType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.inputs.ServiceBusQueueMessageArgs> {
    override fun toJava(): com.pulumi.azurenative.scheduler.inputs.ServiceBusQueueMessageArgs =
        com.pulumi.azurenative.scheduler.inputs.ServiceBusQueueMessageArgs.builder()
            .authentication(authentication?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .brokeredMessageProperties(
                brokeredMessageProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customMessageProperties(
                customMessageProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .message(message?.applyValue({ args0 -> args0 }))
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .queueName(queueName?.applyValue({ args0 -> args0 }))
            .transportType(transportType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ServiceBusQueueMessageArgs].
 */
@PulumiTagMarker
public class ServiceBusQueueMessageArgsBuilder internal constructor() {
    private var authentication: Output<ServiceBusAuthenticationArgs>? = null

    private var brokeredMessageProperties: Output<ServiceBusBrokeredMessagePropertiesArgs>? = null

    private var customMessageProperties: Output<Map<String, String>>? = null

    private var message: Output<String>? = null

    private var namespace: Output<String>? = null

    private var queueName: Output<String>? = null

    private var transportType: Output<ServiceBusTransportType>? = null

    /**
     * @param value Gets or sets the Service Bus authentication.
     */
    @JvmName("bfwvjhuaxqyqpray")
    public suspend fun authentication(`value`: Output<ServiceBusAuthenticationArgs>) {
        this.authentication = value
    }

    /**
     * @param value Gets or sets the brokered message properties.
     */
    @JvmName("uhtdrmrtsvbotrkk")
    public suspend
    fun brokeredMessageProperties(`value`: Output<ServiceBusBrokeredMessagePropertiesArgs>) {
        this.brokeredMessageProperties = value
    }

    /**
     * @param value Gets or sets the custom message properties.
     */
    @JvmName("bqvrpnrhukmcffxx")
    public suspend fun customMessageProperties(`value`: Output<Map<String, String>>) {
        this.customMessageProperties = value
    }

    /**
     * @param value Gets or sets the message.
     */
    @JvmName("wcvlpybnufknfcfl")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value Gets or sets the namespace.
     */
    @JvmName("hgbyrgvvyiukonwp")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value Gets or sets the queue name.
     */
    @JvmName("abufjbckiuxqagei")
    public suspend fun queueName(`value`: Output<String>) {
        this.queueName = value
    }

    /**
     * @param value Gets or sets the transport type.
     */
    @JvmName("rlccrmxemuyxqeiy")
    public suspend fun transportType(`value`: Output<ServiceBusTransportType>) {
        this.transportType = value
    }

    /**
     * @param value Gets or sets the Service Bus authentication.
     */
    @JvmName("enankxjldjktrpvt")
    public suspend fun authentication(`value`: ServiceBusAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param argument Gets or sets the Service Bus authentication.
     */
    @JvmName("cibdpmdkxtdayytv")
    public suspend
    fun authentication(argument: suspend ServiceBusAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceBusAuthenticationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authentication = mapped
    }

    /**
     * @param value Gets or sets the brokered message properties.
     */
    @JvmName("vikpsbehypcitbef")
    public suspend fun brokeredMessageProperties(`value`: ServiceBusBrokeredMessagePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.brokeredMessageProperties = mapped
    }

    /**
     * @param argument Gets or sets the brokered message properties.
     */
    @JvmName("slqfmddigfxtftag")
    public suspend
    fun brokeredMessageProperties(argument: suspend ServiceBusBrokeredMessagePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceBusBrokeredMessagePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.brokeredMessageProperties = mapped
    }

    /**
     * @param value Gets or sets the custom message properties.
     */
    @JvmName("ucloqvcjenvyyrme")
    public suspend fun customMessageProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customMessageProperties = mapped
    }

    /**
     * @param values Gets or sets the custom message properties.
     */
    @JvmName("cxhkucplarqaeehd")
    public fun customMessageProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customMessageProperties = mapped
    }

    /**
     * @param value Gets or sets the message.
     */
    @JvmName("ivpaqmsaquojipjg")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param value Gets or sets the namespace.
     */
    @JvmName("nulvldchifclfqib")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value Gets or sets the queue name.
     */
    @JvmName("qetctcmuhrwgksao")
    public suspend fun queueName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueName = mapped
    }

    /**
     * @param value Gets or sets the transport type.
     */
    @JvmName("wcmmremwhxprcmly")
    public suspend fun transportType(`value`: ServiceBusTransportType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transportType = mapped
    }

    internal fun build(): ServiceBusQueueMessageArgs = ServiceBusQueueMessageArgs(
        authentication = authentication,
        brokeredMessageProperties = brokeredMessageProperties,
        customMessageProperties = customMessageProperties,
        message = message,
        namespace = namespace,
        queueName = queueName,
        transportType = transportType,
    )
}
