@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property frequency Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
 * @property interval Gets or sets the interval between retries.
 */
public data class JobMaxRecurrenceResponse(
    public val frequency: String? = null,
    public val interval: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.scheduler.outputs.JobMaxRecurrenceResponse):
            JobMaxRecurrenceResponse = JobMaxRecurrenceResponse(
            frequency = javaType.frequency().map({ args0 -> args0 }).orElse(null),
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
        )
    }
}
