@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property message Gets or sets the message.
 * @property queueName Gets or sets the queue name.
 * @property sasToken Gets or sets the SAS key.
 * @property storageAccount Gets or sets the storage account name.
 */
public data class StorageQueueMessageResponse(
    public val message: String? = null,
    public val queueName: String? = null,
    public val sasToken: String? = null,
    public val storageAccount: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.scheduler.outputs.StorageQueueMessageResponse):
            StorageQueueMessageResponse = StorageQueueMessageResponse(
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            queueName = javaType.queueName().map({ args0 -> args0 }).orElse(null),
            sasToken = javaType.sasToken().map({ args0 -> args0 }).orElse(null),
            storageAccount = javaType.storageAccount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
