@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin.inputs

import com.pulumi.azurenative.scom.inputs.GetManagedGatewayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceName Name of the SCOM managed instance.
 * @property managedGatewayName The gateway resource name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetManagedGatewayPlainArgs(
    public val instanceName: String,
    public val managedGatewayName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.scom.inputs.GetManagedGatewayPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.scom.inputs.GetManagedGatewayPlainArgs =
        com.pulumi.azurenative.scom.inputs.GetManagedGatewayPlainArgs.builder()
            .instanceName(instanceName.let({ args0 -> args0 }))
            .managedGatewayName(managedGatewayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedGatewayPlainArgs].
 */
@PulumiTagMarker
public class GetManagedGatewayPlainArgsBuilder internal constructor() {
    private var instanceName: String? = null

    private var managedGatewayName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the SCOM managed instance.
     */
    @JvmName("hiupcwrvxpvaavxs")
    public suspend fun instanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceName = mapped
    }

    /**
     * @param value The gateway resource name.
     */
    @JvmName("lndsoumgpnjsskrc")
    public suspend fun managedGatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedGatewayName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qddmpmcjxkqjeiri")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagedGatewayPlainArgs = GetManagedGatewayPlainArgs(
        instanceName = instanceName ?: throw PulumiNullFieldException("instanceName"),
        managedGatewayName = managedGatewayName ?: throw PulumiNullFieldException("managedGatewayName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
