@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin.inputs

import com.pulumi.azurenative.scom.inputs.GmsaDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Gmsa Details
 * @property dnsName Frontend DNS name for Load Balancer which will be used by Agents to initiate communication
 * @property gmsaAccount gMSA account under which context all Management Server services will run
 * @property loadBalancerIP Frontend IP configuration for Load Balancer, which should be an available IP in customer VNet
 * @property managementServerGroupName OnPrem AD Computer Group where we will join VMs for ease of management
 */
public data class GmsaDetailsArgs(
    public val dnsName: Output<String>? = null,
    public val gmsaAccount: Output<String>? = null,
    public val loadBalancerIP: Output<String>? = null,
    public val managementServerGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scom.inputs.GmsaDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.scom.inputs.GmsaDetailsArgs =
        com.pulumi.azurenative.scom.inputs.GmsaDetailsArgs.builder()
            .dnsName(dnsName?.applyValue({ args0 -> args0 }))
            .gmsaAccount(gmsaAccount?.applyValue({ args0 -> args0 }))
            .loadBalancerIP(loadBalancerIP?.applyValue({ args0 -> args0 }))
            .managementServerGroupName(managementServerGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GmsaDetailsArgs].
 */
@PulumiTagMarker
public class GmsaDetailsArgsBuilder internal constructor() {
    private var dnsName: Output<String>? = null

    private var gmsaAccount: Output<String>? = null

    private var loadBalancerIP: Output<String>? = null

    private var managementServerGroupName: Output<String>? = null

    /**
     * @param value Frontend DNS name for Load Balancer which will be used by Agents to initiate communication
     */
    @JvmName("tmslaukeusenrwnv")
    public suspend fun dnsName(`value`: Output<String>) {
        this.dnsName = value
    }

    /**
     * @param value gMSA account under which context all Management Server services will run
     */
    @JvmName("hkyxgqufwifgrvws")
    public suspend fun gmsaAccount(`value`: Output<String>) {
        this.gmsaAccount = value
    }

    /**
     * @param value Frontend IP configuration for Load Balancer, which should be an available IP in customer VNet
     */
    @JvmName("xhqyoqfevruxavbs")
    public suspend fun loadBalancerIP(`value`: Output<String>) {
        this.loadBalancerIP = value
    }

    /**
     * @param value OnPrem AD Computer Group where we will join VMs for ease of management
     */
    @JvmName("mbipsgvebjjoqjky")
    public suspend fun managementServerGroupName(`value`: Output<String>) {
        this.managementServerGroupName = value
    }

    /**
     * @param value Frontend DNS name for Load Balancer which will be used by Agents to initiate communication
     */
    @JvmName("fbynievcudndjpjt")
    public suspend fun dnsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsName = mapped
    }

    /**
     * @param value gMSA account under which context all Management Server services will run
     */
    @JvmName("kgofpakjjdfiybvp")
    public suspend fun gmsaAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gmsaAccount = mapped
    }

    /**
     * @param value Frontend IP configuration for Load Balancer, which should be an available IP in customer VNet
     */
    @JvmName("bkaywsgkpqrmjirs")
    public suspend fun loadBalancerIP(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerIP = mapped
    }

    /**
     * @param value OnPrem AD Computer Group where we will join VMs for ease of management
     */
    @JvmName("mdfbakfuberbcaik")
    public suspend fun managementServerGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementServerGroupName = mapped
    }

    internal fun build(): GmsaDetailsArgs = GmsaDetailsArgs(
        dnsName = dnsName,
        gmsaAccount = gmsaAccount,
        loadBalancerIP = loadBalancerIP,
        managementServerGroupName = managementServerGroupName,
    )
}
