@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Configuration for Log Analytics linking to SCOM managed instance.
 * @property dataTypes The types of data to be ingested to Log Analytics workspace.
 * @property importData A one-time optional parameter to import data of last 7 days.
 * @property workspaceId The resource ID of the Log Analytics workspace to be used.
 */
public data class LogAnalyticsConfigurationResponse(
    public val dataTypes: List<String>? = null,
    public val importData: Boolean? = null,
    public val workspaceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.scom.outputs.LogAnalyticsConfigurationResponse):
            LogAnalyticsConfigurationResponse = LogAnalyticsConfigurationResponse(
            dataTypes = javaType.dataTypes().map({ args0 -> args0 }),
            importData = javaType.importData().map({ args0 -> args0 }).orElse(null),
            workspaceId = javaType.workspaceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
