@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of a gateway resource.
 * @property computerName ComputerName of the gateway to be monitored.
 * @property connectionStatus The connection status of the gateway resource.
 * @property domainName The domain name associated with the gateway to be monitored.
 * @property healthStatus The health status of the gateway resource.
 * @property installType Install type of gateway resource.
 * @property managementServerEndpoint The management server endpoint to which the gateway is directed.
 * @property provisioningState
 * @property resourceId ArmId of the gateway to be monitored.
 * @property resourceLocation Location of the gateway to be monitored.
 * @property version The version of the gateway resource.
 */
public data class ManagedGatewayPropertiesResponse(
    public val computerName: String? = null,
    public val connectionStatus: String,
    public val domainName: String? = null,
    public val healthStatus: String,
    public val installType: String,
    public val managementServerEndpoint: String,
    public val provisioningState: String,
    public val resourceId: String? = null,
    public val resourceLocation: String? = null,
    public val version: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.scom.outputs.ManagedGatewayPropertiesResponse):
            ManagedGatewayPropertiesResponse = ManagedGatewayPropertiesResponse(
            computerName = javaType.computerName().map({ args0 -> args0 }).orElse(null),
            connectionStatus = javaType.connectionStatus(),
            domainName = javaType.domainName().map({ args0 -> args0 }).orElse(null),
            healthStatus = javaType.healthStatus(),
            installType = javaType.installType(),
            managementServerEndpoint = javaType.managementServerEndpoint(),
            provisioningState = javaType.provisioningState(),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            resourceLocation = javaType.resourceLocation().map({ args0 -> args0 }).orElse(null),
            version = javaType.version(),
        )
    }
}
