@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of a monitored resource.
 * @property agentVersion The version of the monitored resource agent version.
 * @property computerName ComputerName of the monitored resource.
 * @property connectionStatus The connection status of the monitored resource.
 * @property domainName The domain name associated with the monitored resource.
 * @property healthStatus The health status of the monitored resource.
 * @property installType Install type of monitored resource.
 * @property managementServerEndpoint The management server endpoint to which the monitored resource is directed.
 * @property provisioningState
 * @property resourceId ArmId of the monitored resource.
 * @property resourceLocation Location of the monitored resource.
 */
public data class MonitoredResourcePropertiesResponse(
    public val agentVersion: String,
    public val computerName: String? = null,
    public val connectionStatus: String,
    public val domainName: String? = null,
    public val healthStatus: String,
    public val installType: String,
    public val managementServerEndpoint: String,
    public val provisioningState: String,
    public val resourceId: String? = null,
    public val resourceLocation: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.scom.outputs.MonitoredResourcePropertiesResponse):
            MonitoredResourcePropertiesResponse = MonitoredResourcePropertiesResponse(
            agentVersion = javaType.agentVersion(),
            computerName = javaType.computerName().map({ args0 -> args0 }).orElse(null),
            connectionStatus = javaType.connectionStatus(),
            domainName = javaType.domainName().map({ args0 -> args0 }).orElse(null),
            healthStatus = javaType.healthStatus(),
            installType = javaType.installType(),
            managementServerEndpoint = javaType.managementServerEndpoint(),
            provisioningState = javaType.provisioningState(),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            resourceLocation = javaType.resourceLocation().map({ args0 -> args0 }).orElse(null),
        )
    }
}
