@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of a SCOM instance resource
 * @property azureHybridBenefit The properties to enable Azure Hybrid benefit for various SCOM infrastructure license.
 * @property databaseInstance The database instance where the SCOM Operational and Warehouse databases will be stored.
 * @property domainController Domain controller details
 * @property domainUserCredentials Domain user which will be used to join VMs to domain and login to VMs.
 * @property gmsaDetails Gmsa Details for load balancer and vmss
 * @property logAnalyticsProperties Details of Log Analytics workspace and data being ingested.
 * @property managementEndpoints List of management server endpoints
 * @property operationsStatus Gets status of current and latest SCOM managed instance operations.
 * @property productVersion SCOM product version to be installed on instance
 * @property provisioningState Gets or sets the provisioning state.
 * @property vNetSubnetId Virtual Network subnet id on which Aquila instance will be provisioned
 */
public data class MonitoringInstancePropertiesResponse(
    public val azureHybridBenefit: AzureHybridBenefitPropertiesResponse? = null,
    public val databaseInstance: DatabaseInstancePropertiesResponse? = null,
    public val domainController: DomainControllerPropertiesResponse? = null,
    public val domainUserCredentials: DomainUserCredentialsResponse? = null,
    public val gmsaDetails: GmsaDetailsResponse? = null,
    public val logAnalyticsProperties: LogAnalyticsConfigurationResponse,
    public val managementEndpoints: List<ManagementServerPropertiesResponse>,
    public val operationsStatus: List<ManagedInstanceOperationStatusResponse>,
    public val productVersion: String,
    public val provisioningState: String,
    public val vNetSubnetId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.scom.outputs.MonitoringInstancePropertiesResponse):
            MonitoringInstancePropertiesResponse = MonitoringInstancePropertiesResponse(
            azureHybridBenefit = javaType.azureHybridBenefit().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scom.kotlin.outputs.AzureHybridBenefitPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            databaseInstance = javaType.databaseInstance().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scom.kotlin.outputs.DatabaseInstancePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            domainController = javaType.domainController().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scom.kotlin.outputs.DomainControllerPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            domainUserCredentials = javaType.domainUserCredentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scom.kotlin.outputs.DomainUserCredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            gmsaDetails = javaType.gmsaDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scom.kotlin.outputs.GmsaDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            logAnalyticsProperties = javaType.logAnalyticsProperties().let({ args0 ->
                com.pulumi.azurenative.scom.kotlin.outputs.LogAnalyticsConfigurationResponse.Companion.toKotlin(args0)
            }),
            managementEndpoints = javaType.managementEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scom.kotlin.outputs.ManagementServerPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            operationsStatus = javaType.operationsStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scom.kotlin.outputs.ManagedInstanceOperationStatusResponse.Companion.toKotlin(args0)
                })
            }),
            productVersion = javaType.productVersion(),
            provisioningState = javaType.provisioningState(),
            vNetSubnetId = javaType.vNetSubnetId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
