@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin

import com.pulumi.azurenative.scvmm.VMInstanceGuestAgentArgs.builder
import com.pulumi.azurenative.scvmm.kotlin.enums.ProvisioningAction
import com.pulumi.azurenative.scvmm.kotlin.inputs.GuestCredentialArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.GuestCredentialArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.HttpProxyConfigurationArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.HttpProxyConfigurationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the GuestAgent.
 * Azure REST API version: 2023-04-01-preview.
 * Other available API versions: 2023-10-07.
 * ## Example Usage
 * ### CreateGuestAgent
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vmInstanceGuestAgent = new AzureNative.ScVmm.VMInstanceGuestAgent("vmInstanceGuestAgent", new()
 *     {
 *         Credentials = new AzureNative.ScVmm.Inputs.GuestCredentialArgs
 *         {
 *             Password = "<password>",
 *             Username = "tempuser",
 *         },
 *         HttpProxyConfig = new AzureNative.ScVmm.Inputs.HttpProxyConfigurationArgs
 *         {
 *             HttpsProxy = "http://192.1.2.3:8080",
 *         },
 *         ProvisioningAction = "install",
 *         ResourceUri = "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scvmm/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scvmm.NewVMInstanceGuestAgent(ctx, "vmInstanceGuestAgent", &scvmm.VMInstanceGuestAgentArgs{
 * 			Credentials: &scvmm.GuestCredentialArgs{
 * 				Password: pulumi.String("<password>"),
 * 				Username: pulumi.String("tempuser"),
 * 			},
 * 			HttpProxyConfig: &scvmm.HttpProxyConfigurationArgs{
 * 				HttpsProxy: pulumi.String("http://192.1.2.3:8080"),
 * 			},
 * 			ProvisioningAction: pulumi.String("install"),
 * 			ResourceUri:        pulumi.String("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scvmm.VMInstanceGuestAgent;
 * import com.pulumi.azurenative.scvmm.VMInstanceGuestAgentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vmInstanceGuestAgent = new VMInstanceGuestAgent("vmInstanceGuestAgent", VMInstanceGuestAgentArgs.builder()
 *             .credentials(Map.ofEntries(
 *                 Map.entry("password", "<password>"),
 *                 Map.entry("username", "tempuser")
 *             ))
 *             .httpProxyConfig(Map.of("httpsProxy", "http://192.1.2.3:8080"))
 *             .provisioningAction("install")
 *             .resourceUri("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scvmm:VMInstanceGuestAgent default /{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default/guestAgents/default
 * ```
 * @property credentials Username / Password Credentials to provision guest agent.
 * @property httpProxyConfig HTTP Proxy configuration for the VM.
 * @property provisioningAction Gets or sets the guest agent provisioning action.
 * @property resourceUri The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
 */
public data class VMInstanceGuestAgentArgs(
    public val credentials: Output<GuestCredentialArgs>? = null,
    public val httpProxyConfig: Output<HttpProxyConfigurationArgs>? = null,
    public val provisioningAction: Output<Either<String, ProvisioningAction>>? = null,
    public val resourceUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.VMInstanceGuestAgentArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.VMInstanceGuestAgentArgs =
        com.pulumi.azurenative.scvmm.VMInstanceGuestAgentArgs.builder()
            .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .httpProxyConfig(httpProxyConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .provisioningAction(
                provisioningAction?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceUri(resourceUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VMInstanceGuestAgentArgs].
 */
@PulumiTagMarker
public class VMInstanceGuestAgentArgsBuilder internal constructor() {
    private var credentials: Output<GuestCredentialArgs>? = null

    private var httpProxyConfig: Output<HttpProxyConfigurationArgs>? = null

    private var provisioningAction: Output<Either<String, ProvisioningAction>>? = null

    private var resourceUri: Output<String>? = null

    /**
     * @param value Username / Password Credentials to provision guest agent.
     */
    @JvmName("hpdumitirjvrgeig")
    public suspend fun credentials(`value`: Output<GuestCredentialArgs>) {
        this.credentials = value
    }

    /**
     * @param value HTTP Proxy configuration for the VM.
     */
    @JvmName("gqryqndanpjibtls")
    public suspend fun httpProxyConfig(`value`: Output<HttpProxyConfigurationArgs>) {
        this.httpProxyConfig = value
    }

    /**
     * @param value Gets or sets the guest agent provisioning action.
     */
    @JvmName("fshptsmsmnxlujbv")
    public suspend fun provisioningAction(`value`: Output<Either<String, ProvisioningAction>>) {
        this.provisioningAction = value
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
     */
    @JvmName("smphvrnfgsfosawb")
    public suspend fun resourceUri(`value`: Output<String>) {
        this.resourceUri = value
    }

    /**
     * @param value Username / Password Credentials to provision guest agent.
     */
    @JvmName("xfektjeajqjyjdfv")
    public suspend fun credentials(`value`: GuestCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument Username / Password Credentials to provision guest agent.
     */
    @JvmName("igicjiravaoudxqv")
    public suspend fun credentials(argument: suspend GuestCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = GuestCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value HTTP Proxy configuration for the VM.
     */
    @JvmName("hdmpmsflxwnbdhco")
    public suspend fun httpProxyConfig(`value`: HttpProxyConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpProxyConfig = mapped
    }

    /**
     * @param argument HTTP Proxy configuration for the VM.
     */
    @JvmName("lwfhhvukakcoymoo")
    public suspend
    fun httpProxyConfig(argument: suspend HttpProxyConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = HttpProxyConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpProxyConfig = mapped
    }

    /**
     * @param value Gets or sets the guest agent provisioning action.
     */
    @JvmName("fnasqgcutmvdrqik")
    public suspend fun provisioningAction(`value`: Either<String, ProvisioningAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningAction = mapped
    }

    /**
     * @param value Gets or sets the guest agent provisioning action.
     */
    @JvmName("gwpvgdipqvehmgak")
    public fun provisioningAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningAction = mapped
    }

    /**
     * @param value Gets or sets the guest agent provisioning action.
     */
    @JvmName("xvviipxjkwvldkxu")
    public fun provisioningAction(`value`: ProvisioningAction) {
        val toBeMapped = Either.ofRight<String, ProvisioningAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningAction = mapped
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
     */
    @JvmName("djnwgdqshuwydnxd")
    public suspend fun resourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUri = mapped
    }

    internal fun build(): VMInstanceGuestAgentArgs = VMInstanceGuestAgentArgs(
        credentials = credentials,
        httpProxyConfig = httpProxyConfig,
        provisioningAction = provisioningAction,
        resourceUri = resourceUri,
    )
}
