@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.NetworkProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the resource properties.
 * @property networkInterfaces Gets or sets the list of network interfaces associated with the virtual machine.
 */
public data class NetworkProfileArgs(
    public val networkInterfaces: Output<List<NetworkInterfacesArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.NetworkProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.NetworkProfileArgs =
        com.pulumi.azurenative.scvmm.inputs.NetworkProfileArgs.builder()
            .networkInterfaces(
                networkInterfaces?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkProfileArgs].
 */
@PulumiTagMarker
public class NetworkProfileArgsBuilder internal constructor() {
    private var networkInterfaces: Output<List<NetworkInterfacesArgs>>? = null

    /**
     * @param value Gets or sets the list of network interfaces associated with the virtual machine.
     */
    @JvmName("kystgaditxnobqfb")
    public suspend fun networkInterfaces(`value`: Output<List<NetworkInterfacesArgs>>) {
        this.networkInterfaces = value
    }

    @JvmName("qjsqdnmrfgakcdba")
    public suspend fun networkInterfaces(vararg values: Output<NetworkInterfacesArgs>) {
        this.networkInterfaces = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of network interfaces associated with the virtual machine.
     */
    @JvmName("dyogptfohpsbkdjb")
    public suspend fun networkInterfaces(values: List<Output<NetworkInterfacesArgs>>) {
        this.networkInterfaces = Output.all(values)
    }

    /**
     * @param value Gets or sets the list of network interfaces associated with the virtual machine.
     */
    @JvmName("unhbjyydsjxcooqw")
    public suspend fun networkInterfaces(`value`: List<NetworkInterfacesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param argument Gets or sets the list of network interfaces associated with the virtual machine.
     */
    @JvmName("yjkgferakvufxniu")
    public suspend
    fun networkInterfaces(argument: List<suspend NetworkInterfacesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkInterfacesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument Gets or sets the list of network interfaces associated with the virtual machine.
     */
    @JvmName("nkjwbmscktolgvrx")
    public suspend fun networkInterfaces(
        vararg
        argument: suspend NetworkInterfacesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NetworkInterfacesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument Gets or sets the list of network interfaces associated with the virtual machine.
     */
    @JvmName("vggpqcthdvicaujh")
    public suspend fun networkInterfaces(argument: suspend NetworkInterfacesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NetworkInterfacesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param values Gets or sets the list of network interfaces associated with the virtual machine.
     */
    @JvmName("ixusgyuylfrbjtmk")
    public suspend fun networkInterfaces(vararg values: NetworkInterfacesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    internal fun build(): NetworkProfileArgs = NetworkProfileArgs(
        networkInterfaces = networkInterfaces,
    )
}
