@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.OsProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the resource properties.
 * @property adminPassword Admin password of the virtual machine.
 * @property computerName Gets or sets computer name.
 */
public data class OsProfileArgs(
    public val adminPassword: Output<String>? = null,
    public val computerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.OsProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.OsProfileArgs =
        com.pulumi.azurenative.scvmm.inputs.OsProfileArgs.builder()
            .adminPassword(adminPassword?.applyValue({ args0 -> args0 }))
            .computerName(computerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OsProfileArgs].
 */
@PulumiTagMarker
public class OsProfileArgsBuilder internal constructor() {
    private var adminPassword: Output<String>? = null

    private var computerName: Output<String>? = null

    /**
     * @param value Admin password of the virtual machine.
     */
    @JvmName("hxptjohvjjnodbfm")
    public suspend fun adminPassword(`value`: Output<String>) {
        this.adminPassword = value
    }

    /**
     * @param value Gets or sets computer name.
     */
    @JvmName("slqnuyjaamrapnii")
    public suspend fun computerName(`value`: Output<String>) {
        this.computerName = value
    }

    /**
     * @param value Admin password of the virtual machine.
     */
    @JvmName("hkljadyxnminwndy")
    public suspend fun adminPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminPassword = mapped
    }

    /**
     * @param value Gets or sets computer name.
     */
    @JvmName("rxmownocoidalqsq")
    public suspend fun computerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computerName = mapped
    }

    internal fun build(): OsProfileArgs = OsProfileArgs(
        adminPassword = adminPassword,
        computerName = computerName,
    )
}
