@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the resource properties.
 * @property checkpointID Gets ID of the checkpoint.
 * @property description Gets description of the checkpoint.
 * @property name Gets name of the checkpoint.
 * @property parentCheckpointID Gets ID of parent of the checkpoint.
 */
public data class CheckpointResponse(
    public val checkpointID: String? = null,
    public val description: String? = null,
    public val name: String? = null,
    public val parentCheckpointID: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scvmm.outputs.CheckpointResponse):
            CheckpointResponse = CheckpointResponse(
            checkpointID = javaType.checkpointID().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            parentCheckpointID = javaType.parentCheckpointID().map({ args0 -> args0 }).orElse(null),
        )
    }
}
