@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The VirtualMachines resource definition.
 * @property availabilitySets Availability Sets in vm.
 * @property checkpointType Type of checkpoint supported for the vm.
 * @property checkpoints Checkpoints in the vm.
 * @property cloudId ARM Id of the cloud resource to use for deploying the vm.
 * @property extendedLocation The extended location.
 * @property generation Gets or sets the generation for the vm.
 * @property guestAgentProfile Guest agent status properties.
 * @property hardwareProfile Hardware properties.
 * @property id Resource Id
 * @property identity The identity of the resource.
 * @property inventoryItemId Gets or sets the inventory Item ID for the resource.
 * @property lastRestoredVMCheckpoint Last restored checkpoint in the vm.
 * @property location Gets or sets the location.
 * @property name Resource Name
 * @property networkProfile Network properties.
 * @property osProfile OS properties.
 * @property powerState Gets the power state of the virtual machine.
 * @property provisioningState Gets or sets the provisioning state.
 * @property storageProfile Storage properties.
 * @property systemData The system data.
 * @property tags Resource tags
 * @property templateId ARM Id of the template resource to use for deploying the vm.
 * @property type Resource Type
 * @property uuid Unique ID of the virtual machine.
 * @property vmName VMName is the name of VM on the SCVMM server.
 * @property vmmServerId ARM Id of the vmmServer resource in which this resource resides.
 */
public data class GetVirtualMachineResult(
    public val availabilitySets: List<VirtualMachinePropertiesResponseAvailabilitySets>? = null,
    public val checkpointType: String? = null,
    public val checkpoints: List<CheckpointResponse>? = null,
    public val cloudId: String? = null,
    public val extendedLocation: ExtendedLocationResponse,
    public val generation: Int? = null,
    public val guestAgentProfile: GuestAgentProfileResponse? = null,
    public val hardwareProfile: HardwareProfileResponse? = null,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val inventoryItemId: String? = null,
    public val lastRestoredVMCheckpoint: CheckpointResponse,
    public val location: String,
    public val name: String,
    public val networkProfile: NetworkProfileResponse? = null,
    public val osProfile: OsProfileResponse? = null,
    public val powerState: String,
    public val provisioningState: String,
    public val storageProfile: StorageProfileResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val templateId: String? = null,
    public val type: String,
    public val uuid: String? = null,
    public val vmName: String? = null,
    public val vmmServerId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scvmm.outputs.GetVirtualMachineResult):
            GetVirtualMachineResult = GetVirtualMachineResult(
            availabilitySets = javaType.availabilitySets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.VirtualMachinePropertiesResponseAvailabilitySets.Companion.toKotlin(args0)
                })
            }),
            checkpointType = javaType.checkpointType().map({ args0 -> args0 }).orElse(null),
            checkpoints = javaType.checkpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.CheckpointResponse.Companion.toKotlin(args0)
                })
            }),
            cloudId = javaType.cloudId().map({ args0 -> args0 }).orElse(null),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.scvmm.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            generation = javaType.generation().map({ args0 -> args0 }).orElse(null),
            guestAgentProfile = javaType.guestAgentProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.GuestAgentProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hardwareProfile = javaType.hardwareProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.HardwareProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            inventoryItemId = javaType.inventoryItemId().map({ args0 -> args0 }).orElse(null),
            lastRestoredVMCheckpoint = javaType.lastRestoredVMCheckpoint().let({ args0 ->
                com.pulumi.azurenative.scvmm.kotlin.outputs.CheckpointResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location(),
            name = javaType.name(),
            networkProfile = javaType.networkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osProfile = javaType.osProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.OsProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            powerState = javaType.powerState(),
            provisioningState = javaType.provisioningState(),
            storageProfile = javaType.storageProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.StorageProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            templateId = javaType.templateId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            uuid = javaType.uuid().map({ args0 -> args0 }).orElse(null),
            vmName = javaType.vmName().map({ args0 -> args0 }).orElse(null),
            vmmServerId = javaType.vmmServerId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
