@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines the resource properties.
 * @property disks Gets or sets the list of virtual disks associated with the virtual machine.
 */
public data class StorageProfileResponse(
    public val disks: List<VirtualDiskResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scvmm.outputs.StorageProfileResponse):
            StorageProfileResponse = StorageProfileResponse(
            disks = javaType.disks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.VirtualDiskResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
