@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin

import com.pulumi.azurenative.search.kotlin.outputs.DataPlaneAuthOptionsResponse
import com.pulumi.azurenative.search.kotlin.outputs.EncryptionWithCmkResponse
import com.pulumi.azurenative.search.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.search.kotlin.outputs.NetworkRuleSetResponse
import com.pulumi.azurenative.search.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.search.kotlin.outputs.SharedPrivateLinkResourceResponse
import com.pulumi.azurenative.search.kotlin.outputs.SkuResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.search.kotlin.outputs.DataPlaneAuthOptionsResponse.Companion.toKotlin as dataPlaneAuthOptionsResponseToKotlin
import com.pulumi.azurenative.search.kotlin.outputs.EncryptionWithCmkResponse.Companion.toKotlin as encryptionWithCmkResponseToKotlin
import com.pulumi.azurenative.search.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.search.kotlin.outputs.NetworkRuleSetResponse.Companion.toKotlin as networkRuleSetResponseToKotlin
import com.pulumi.azurenative.search.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.search.kotlin.outputs.SharedPrivateLinkResourceResponse.Companion.toKotlin as sharedPrivateLinkResourceResponseToKotlin
import com.pulumi.azurenative.search.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin

/**
 * Builder for [Service].
 */
@PulumiTagMarker
public class ServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceArgs = ServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceArgsBuilder.() -> Unit) {
        val builder = ServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Service {
        val builtJavaResource = com.pulumi.azurenative.search.Service(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Service(builtJavaResource)
    }
}

/**
 * Describes an Azure Cognitive Search service and its current state.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-08-01.
 * Other available API versions: 2021-04-01-preview, 2023-11-01.
 * ## Example Usage
 * ### SearchCreateOrUpdateService
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.Search.Service("service", new()
 *     {
 *         HostingMode = AzureNative.Search.HostingMode.Default,
 *         Location = "westus",
 *         PartitionCount = 1,
 *         ReplicaCount = 3,
 *         ResourceGroupName = "rg1",
 *         SearchServiceName = "mysearchservice",
 *         Sku = new AzureNative.Search.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Search.SkuName.Standard,
 *         },
 *         Tags =
 *         {
 *             { "app-name", "My e-commerce app" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/search/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := search.NewService(ctx, "service", &search.ServiceArgs{
 * 			HostingMode:       search.HostingModeDefault,
 * 			Location:          pulumi.String("westus"),
 * 			PartitionCount:    pulumi.Int(1),
 * 			ReplicaCount:      pulumi.Int(3),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SearchServiceName: pulumi.String("mysearchservice"),
 * 			Sku: &search.SkuArgs{
 * 				Name: search.SkuNameStandard,
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"app-name": pulumi.String("My e-commerce app"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.search.Service;
 * import com.pulumi.azurenative.search.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .hostingMode("default")
 *             .location("westus")
 *             .partitionCount(1)
 *             .replicaCount(3)
 *             .resourceGroupName("rg1")
 *             .searchServiceName("mysearchservice")
 *             .sku(Map.of("name", "standard"))
 *             .tags(Map.of("app-name", "My e-commerce app"))
 *             .build());
 *     }
 * }
 * ```
 * ### SearchCreateOrUpdateServiceAuthOptions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.Search.Service("service", new()
 *     {
 *         AuthOptions = new AzureNative.Search.Inputs.DataPlaneAuthOptionsArgs
 *         {
 *             AadOrApiKey = new AzureNative.Search.Inputs.DataPlaneAadOrApiKeyAuthOptionArgs
 *             {
 *                 AadAuthFailureMode = AzureNative.Search.AadAuthFailureMode.Http401WithBearerChallenge,
 *             },
 *         },
 *         HostingMode = AzureNative.Search.HostingMode.Default,
 *         Location = "westus",
 *         PartitionCount = 1,
 *         ReplicaCount = 3,
 *         ResourceGroupName = "rg1",
 *         SearchServiceName = "mysearchservice",
 *         Sku = new AzureNative.Search.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Search.SkuName.Standard,
 *         },
 *         Tags =
 *         {
 *             { "app-name", "My e-commerce app" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/search/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := search.NewService(ctx, "service", &search.ServiceArgs{
 * 			AuthOptions: search.DataPlaneAuthOptionsResponse{
 * 				AadOrApiKey: &search.DataPlaneAadOrApiKeyAuthOptionArgs{
 * 					AadAuthFailureMode: search.AadAuthFailureModeHttp401WithBearerChallenge,
 * 				},
 * 			},
 * 			HostingMode:       search.HostingModeDefault,
 * 			Location:          pulumi.String("westus"),
 * 			PartitionCount:    pulumi.Int(1),
 * 			ReplicaCount:      pulumi.Int(3),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SearchServiceName: pulumi.String("mysearchservice"),
 * 			Sku: &search.SkuArgs{
 * 				Name: search.SkuNameStandard,
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"app-name": pulumi.String("My e-commerce app"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.search.Service;
 * import com.pulumi.azurenative.search.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .authOptions(Map.of("aadOrApiKey", Map.of("aadAuthFailureMode", "http401WithBearerChallenge")))
 *             .hostingMode("default")
 *             .location("westus")
 *             .partitionCount(1)
 *             .replicaCount(3)
 *             .resourceGroupName("rg1")
 *             .searchServiceName("mysearchservice")
 *             .sku(Map.of("name", "standard"))
 *             .tags(Map.of("app-name", "My e-commerce app"))
 *             .build());
 *     }
 * }
 * ```
 * ### SearchCreateOrUpdateServiceDisableLocalAuth
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.Search.Service("service", new()
 *     {
 *         DisableLocalAuth = true,
 *         HostingMode = AzureNative.Search.HostingMode.Default,
 *         Location = "westus",
 *         PartitionCount = 1,
 *         ReplicaCount = 3,
 *         ResourceGroupName = "rg1",
 *         SearchServiceName = "mysearchservice",
 *         Sku = new AzureNative.Search.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Search.SkuName.Standard,
 *         },
 *         Tags =
 *         {
 *             { "app-name", "My e-commerce app" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/search/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := search.NewService(ctx, "service", &search.ServiceArgs{
 * 			DisableLocalAuth:  pulumi.Bool(true),
 * 			HostingMode:       search.HostingModeDefault,
 * 			Location:          pulumi.String("westus"),
 * 			PartitionCount:    pulumi.Int(1),
 * 			ReplicaCount:      pulumi.Int(3),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SearchServiceName: pulumi.String("mysearchservice"),
 * 			Sku: &search.SkuArgs{
 * 				Name: search.SkuNameStandard,
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"app-name": pulumi.String("My e-commerce app"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.search.Service;
 * import com.pulumi.azurenative.search.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .disableLocalAuth(true)
 *             .hostingMode("default")
 *             .location("westus")
 *             .partitionCount(1)
 *             .replicaCount(3)
 *             .resourceGroupName("rg1")
 *             .searchServiceName("mysearchservice")
 *             .sku(Map.of("name", "standard"))
 *             .tags(Map.of("app-name", "My e-commerce app"))
 *             .build());
 *     }
 * }
 * ```
 * ### SearchCreateOrUpdateServiceToAllowAccessFromPrivateEndpoints
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.Search.Service("service", new()
 *     {
 *         HostingMode = AzureNative.Search.HostingMode.Default,
 *         Location = "westus",
 *         PartitionCount = 1,
 *         PublicNetworkAccess = AzureNative.Search.PublicNetworkAccess.Disabled,
 *         ReplicaCount = 3,
 *         ResourceGroupName = "rg1",
 *         SearchServiceName = "mysearchservice",
 *         Sku = new AzureNative.Search.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Search.SkuName.Standard,
 *         },
 *         Tags =
 *         {
 *             { "app-name", "My e-commerce app" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/search/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := search.NewService(ctx, "service", &search.ServiceArgs{
 * 			HostingMode:         search.HostingModeDefault,
 * 			Location:            pulumi.String("westus"),
 * 			PartitionCount:      pulumi.Int(1),
 * 			PublicNetworkAccess: search.PublicNetworkAccessDisabled,
 * 			ReplicaCount:        pulumi.Int(3),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			SearchServiceName:   pulumi.String("mysearchservice"),
 * 			Sku: &search.SkuArgs{
 * 				Name: search.SkuNameStandard,
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"app-name": pulumi.String("My e-commerce app"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.search.Service;
 * import com.pulumi.azurenative.search.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .hostingMode("default")
 *             .location("westus")
 *             .partitionCount(1)
 *             .publicNetworkAccess("disabled")
 *             .replicaCount(3)
 *             .resourceGroupName("rg1")
 *             .searchServiceName("mysearchservice")
 *             .sku(Map.of("name", "standard"))
 *             .tags(Map.of("app-name", "My e-commerce app"))
 *             .build());
 *     }
 * }
 * ```
 * ### SearchCreateOrUpdateServiceToAllowAccessFromPublicCustomIPs
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.Search.Service("service", new()
 *     {
 *         HostingMode = AzureNative.Search.HostingMode.Default,
 *         Location = "westus",
 *         NetworkRuleSet = new AzureNative.Search.Inputs.NetworkRuleSetArgs
 *         {
 *             IpRules = new[]
 *             {
 *                 new AzureNative.Search.Inputs.IpRuleArgs
 *                 {
 *                     Value = "123.4.5.6",
 *                 },
 *                 new AzureNative.Search.Inputs.IpRuleArgs
 *                 {
 *                     Value = "123.4.6.0/18",
 *                 },
 *             },
 *         },
 *         PartitionCount = 1,
 *         ReplicaCount = 1,
 *         ResourceGroupName = "rg1",
 *         SearchServiceName = "mysearchservice",
 *         Sku = new AzureNative.Search.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Search.SkuName.Standard,
 *         },
 *         Tags =
 *         {
 *             { "app-name", "My e-commerce app" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/search/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := search.NewService(ctx, "service", &search.ServiceArgs{
 * 			HostingMode: search.HostingModeDefault,
 * 			Location:    pulumi.String("westus"),
 * 			NetworkRuleSet: search.NetworkRuleSetResponse{
 * 				IpRules: search.IpRuleArray{
 * 					&search.IpRuleArgs{
 * 						Value: pulumi.String("123.4.5.6"),
 * 					},
 * 					&search.IpRuleArgs{
 * 						Value: pulumi.String("123.4.6.0/18"),
 * 					},
 * 				},
 * 			},
 * 			PartitionCount:    pulumi.Int(1),
 * 			ReplicaCount:      pulumi.Int(1),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SearchServiceName: pulumi.String("mysearchservice"),
 * 			Sku: &search.SkuArgs{
 * 				Name: search.SkuNameStandard,
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"app-name": pulumi.String("My e-commerce app"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.search.Service;
 * import com.pulumi.azurenative.search.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .hostingMode("default")
 *             .location("westus")
 *             .networkRuleSet(Map.of("ipRules",
 *                 Map.of("value", "123.4.5.6"),
 *                 Map.of("value", "123.4.6.0/18")))
 *             .partitionCount(1)
 *             .replicaCount(1)
 *             .resourceGroupName("rg1")
 *             .searchServiceName("mysearchservice")
 *             .sku(Map.of("name", "standard"))
 *             .tags(Map.of("app-name", "My e-commerce app"))
 *             .build());
 *     }
 * }
 * ```
 * ### SearchCreateOrUpdateServiceWithCmkEnforcement
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.Search.Service("service", new()
 *     {
 *         EncryptionWithCmk = new AzureNative.Search.Inputs.EncryptionWithCmkArgs
 *         {
 *             Enforcement = AzureNative.Search.SearchEncryptionWithCmk.Enabled,
 *         },
 *         HostingMode = AzureNative.Search.HostingMode.Default,
 *         Location = "westus",
 *         PartitionCount = 1,
 *         ReplicaCount = 3,
 *         ResourceGroupName = "rg1",
 *         SearchServiceName = "mysearchservice",
 *         Sku = new AzureNative.Search.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Search.SkuName.Standard,
 *         },
 *         Tags =
 *         {
 *             { "app-name", "My e-commerce app" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/search/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := search.NewService(ctx, "service", &search.ServiceArgs{
 * 			EncryptionWithCmk: &search.EncryptionWithCmkArgs{
 * 				Enforcement: search.SearchEncryptionWithCmkEnabled,
 * 			},
 * 			HostingMode:       search.HostingModeDefault,
 * 			Location:          pulumi.String("westus"),
 * 			PartitionCount:    pulumi.Int(1),
 * 			ReplicaCount:      pulumi.Int(3),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SearchServiceName: pulumi.String("mysearchservice"),
 * 			Sku: &search.SkuArgs{
 * 				Name: search.SkuNameStandard,
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"app-name": pulumi.String("My e-commerce app"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.search.Service;
 * import com.pulumi.azurenative.search.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .encryptionWithCmk(Map.of("enforcement", "Enabled"))
 *             .hostingMode("default")
 *             .location("westus")
 *             .partitionCount(1)
 *             .replicaCount(3)
 *             .resourceGroupName("rg1")
 *             .searchServiceName("mysearchservice")
 *             .sku(Map.of("name", "standard"))
 *             .tags(Map.of("app-name", "My e-commerce app"))
 *             .build());
 *     }
 * }
 * ```
 * ### SearchCreateOrUpdateServiceWithIdentity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.Search.Service("service", new()
 *     {
 *         HostingMode = AzureNative.Search.HostingMode.Default,
 *         Identity = new AzureNative.Search.Inputs.IdentityArgs
 *         {
 *             Type = AzureNative.Search.IdentityType.SystemAssigned,
 *         },
 *         Location = "westus",
 *         PartitionCount = 1,
 *         ReplicaCount = 3,
 *         ResourceGroupName = "rg1",
 *         SearchServiceName = "mysearchservice",
 *         Sku = new AzureNative.Search.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Search.SkuName.Standard,
 *         },
 *         Tags =
 *         {
 *             { "app-name", "My e-commerce app" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/search/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := search.NewService(ctx, "service", &search.ServiceArgs{
 * 			HostingMode: search.HostingModeDefault,
 * 			Identity: &search.IdentityArgs{
 * 				Type: search.IdentityTypeSystemAssigned,
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			PartitionCount:    pulumi.Int(1),
 * 			ReplicaCount:      pulumi.Int(3),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SearchServiceName: pulumi.String("mysearchservice"),
 * 			Sku: &search.SkuArgs{
 * 				Name: search.SkuNameStandard,
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"app-name": pulumi.String("My e-commerce app"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.search.Service;
 * import com.pulumi.azurenative.search.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .hostingMode("default")
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .location("westus")
 *             .partitionCount(1)
 *             .replicaCount(3)
 *             .resourceGroupName("rg1")
 *             .searchServiceName("mysearchservice")
 *             .sku(Map.of("name", "standard"))
 *             .tags(Map.of("app-name", "My e-commerce app"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:search:Service mysearchservice /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}
 * ```
 */
public class Service internal constructor(
    override val javaResource: com.pulumi.azurenative.search.Service,
) : KotlinCustomResource(javaResource, ServiceMapper) {
    /**
     * Defines the options for how the data plane API of a search service authenticates requests. This cannot be set if 'disableLocalAuth' is set to true.
     */
    public val authOptions: Output<DataPlaneAuthOptionsResponse>?
        get() = javaResource.authOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataPlaneAuthOptionsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * When set to true, calls to the search service will not be permitted to utilize API keys for authentication. This cannot be set to true if 'dataPlaneAuthOptions' are defined.
     */
    public val disableLocalAuth: Output<Boolean>?
        get() = javaResource.disableLocalAuth().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies any policy regarding encryption of resources (such as indexes) using customer manager keys within a search service.
     */
    public val encryptionWithCmk: Output<EncryptionWithCmkResponse>?
        get() = javaResource.encryptionWithCmk().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> encryptionWithCmkResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Applicable only for the standard3 SKU. You can set this property to enable up to 3 high density partitions that allow up to 1000 indexes, which is much higher than the maximum indexes allowed for any other SKU. For the standard3 SKU, the value is either 'default' or 'highDensity'. For all other SKUs, this value must be 'default'.
     */
    public val hostingMode: Output<String>?
        get() = javaResource.hostingMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The identity of the resource.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network specific rules that determine how the Azure Cognitive Search service may be reached.
     */
    public val networkRuleSet: Output<NetworkRuleSetResponse>?
        get() = javaResource.networkRuleSet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkRuleSetResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The number of partitions in the search service; if specified, it can be 1, 2, 3, 4, 6, or 12. Values greater than 1 are only valid for standard SKUs. For 'standard3' services with hostingMode set to 'highDensity', the allowed values are between 1 and 3.
     */
    public val partitionCount: Output<Int>?
        get() = javaResource.partitionCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of private endpoint connections to the Azure Cognitive Search service.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * The state of the last provisioning operation performed on the search service. Provisioning is an intermediate state that occurs while service capacity is being established. After capacity is set up, provisioningState changes to either 'succeeded' or 'failed'. Client applications can poll provisioning status (the recommended polling interval is from 30 seconds to one minute) by using the Get Search Service operation to see when an operation is completed. If you are using the free service, this value tends to come back as 'succeeded' directly in the call to Create search service. This is because the free service uses capacity that is already set up.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * This value can be set to 'enabled' to avoid breaking changes on existing customer resources and templates. If set to 'disabled', traffic over public interface is not allowed, and private endpoint connections would be the exclusive access method.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of replicas in the search service. If specified, it must be a value between 1 and 12 inclusive for standard SKUs or between 1 and 3 inclusive for basic SKU.
     */
    public val replicaCount: Output<Int>?
        get() = javaResource.replicaCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of shared private link resources managed by the Azure Cognitive Search service.
     */
    public val sharedPrivateLinkResources: Output<List<SharedPrivateLinkResourceResponse>>
        get() = javaResource.sharedPrivateLinkResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> sharedPrivateLinkResourceResponseToKotlin(args0) })
            })
        })

    /**
     * The SKU of the Search Service, which determines price tier and capacity limits. This property is required when creating a new Search Service.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The status of the search service. Possible values include: 'running': The search service is running and no provisioning operations are underway. 'provisioning': The search service is being provisioned or scaled up or down. 'deleting': The search service is being deleted. 'degraded': The search service is degraded. This can occur when the underlying search units are not healthy. The search service is most likely operational, but performance might be slow and some requests might be dropped. 'disabled': The search service is disabled. In this state, the service will reject all API requests. 'error': The search service is in an error state. If your service is in the degraded, disabled, or error states, it means the Azure Cognitive Search team is actively investigating the underlying issue. Dedicated services in these states are still chargeable based on the number of search units provisioned.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The details of the search service status.
     */
    public val statusDetails: Output<String>
        get() = javaResource.statusDetails().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServiceMapper : ResourceMapper<Service> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.search.Service::class == javaResource::class

    override fun map(javaResource: Resource): Service = Service(
        javaResource as
            com.pulumi.azurenative.search.Service,
    )
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Service].
 */
public suspend fun service(name: String, block: suspend ServiceResourceBuilder.() -> Unit):
    Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 */
public fun service(name: String): Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
