@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin

import com.pulumi.azurenative.search.ServiceArgs.builder
import com.pulumi.azurenative.search.kotlin.enums.HostingMode
import com.pulumi.azurenative.search.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.search.kotlin.inputs.DataPlaneAuthOptionsArgs
import com.pulumi.azurenative.search.kotlin.inputs.DataPlaneAuthOptionsArgsBuilder
import com.pulumi.azurenative.search.kotlin.inputs.EncryptionWithCmkArgs
import com.pulumi.azurenative.search.kotlin.inputs.EncryptionWithCmkArgsBuilder
import com.pulumi.azurenative.search.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.search.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.search.kotlin.inputs.NetworkRuleSetArgs
import com.pulumi.azurenative.search.kotlin.inputs.NetworkRuleSetArgsBuilder
import com.pulumi.azurenative.search.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.search.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes an Azure Cognitive Search service and its current state.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-08-01.
 * Other available API versions: 2021-04-01-preview, 2023-11-01.
 * ## Example Usage
 * ### SearchCreateOrUpdateService
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.Search.Service("service", new()
 *     {
 *         HostingMode = AzureNative.Search.HostingMode.Default,
 *         Location = "westus",
 *         PartitionCount = 1,
 *         ReplicaCount = 3,
 *         ResourceGroupName = "rg1",
 *         SearchServiceName = "mysearchservice",
 *         Sku = new AzureNative.Search.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Search.SkuName.Standard,
 *         },
 *         Tags =
 *         {
 *             { "app-name", "My e-commerce app" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/search/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := search.NewService(ctx, "service", &search.ServiceArgs{
 * 			HostingMode:       search.HostingModeDefault,
 * 			Location:          pulumi.String("westus"),
 * 			PartitionCount:    pulumi.Int(1),
 * 			ReplicaCount:      pulumi.Int(3),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SearchServiceName: pulumi.String("mysearchservice"),
 * 			Sku: &search.SkuArgs{
 * 				Name: search.SkuNameStandard,
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"app-name": pulumi.String("My e-commerce app"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.search.Service;
 * import com.pulumi.azurenative.search.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .hostingMode("default")
 *             .location("westus")
 *             .partitionCount(1)
 *             .replicaCount(3)
 *             .resourceGroupName("rg1")
 *             .searchServiceName("mysearchservice")
 *             .sku(Map.of("name", "standard"))
 *             .tags(Map.of("app-name", "My e-commerce app"))
 *             .build());
 *     }
 * }
 * ```
 * ### SearchCreateOrUpdateServiceAuthOptions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.Search.Service("service", new()
 *     {
 *         AuthOptions = new AzureNative.Search.Inputs.DataPlaneAuthOptionsArgs
 *         {
 *             AadOrApiKey = new AzureNative.Search.Inputs.DataPlaneAadOrApiKeyAuthOptionArgs
 *             {
 *                 AadAuthFailureMode = AzureNative.Search.AadAuthFailureMode.Http401WithBearerChallenge,
 *             },
 *         },
 *         HostingMode = AzureNative.Search.HostingMode.Default,
 *         Location = "westus",
 *         PartitionCount = 1,
 *         ReplicaCount = 3,
 *         ResourceGroupName = "rg1",
 *         SearchServiceName = "mysearchservice",
 *         Sku = new AzureNative.Search.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Search.SkuName.Standard,
 *         },
 *         Tags =
 *         {
 *             { "app-name", "My e-commerce app" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/search/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := search.NewService(ctx, "service", &search.ServiceArgs{
 * 			AuthOptions: search.DataPlaneAuthOptionsResponse{
 * 				AadOrApiKey: &search.DataPlaneAadOrApiKeyAuthOptionArgs{
 * 					AadAuthFailureMode: search.AadAuthFailureModeHttp401WithBearerChallenge,
 * 				},
 * 			},
 * 			HostingMode:       search.HostingModeDefault,
 * 			Location:          pulumi.String("westus"),
 * 			PartitionCount:    pulumi.Int(1),
 * 			ReplicaCount:      pulumi.Int(3),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SearchServiceName: pulumi.String("mysearchservice"),
 * 			Sku: &search.SkuArgs{
 * 				Name: search.SkuNameStandard,
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"app-name": pulumi.String("My e-commerce app"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.search.Service;
 * import com.pulumi.azurenative.search.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .authOptions(Map.of("aadOrApiKey", Map.of("aadAuthFailureMode", "http401WithBearerChallenge")))
 *             .hostingMode("default")
 *             .location("westus")
 *             .partitionCount(1)
 *             .replicaCount(3)
 *             .resourceGroupName("rg1")
 *             .searchServiceName("mysearchservice")
 *             .sku(Map.of("name", "standard"))
 *             .tags(Map.of("app-name", "My e-commerce app"))
 *             .build());
 *     }
 * }
 * ```
 * ### SearchCreateOrUpdateServiceDisableLocalAuth
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.Search.Service("service", new()
 *     {
 *         DisableLocalAuth = true,
 *         HostingMode = AzureNative.Search.HostingMode.Default,
 *         Location = "westus",
 *         PartitionCount = 1,
 *         ReplicaCount = 3,
 *         ResourceGroupName = "rg1",
 *         SearchServiceName = "mysearchservice",
 *         Sku = new AzureNative.Search.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Search.SkuName.Standard,
 *         },
 *         Tags =
 *         {
 *             { "app-name", "My e-commerce app" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/search/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := search.NewService(ctx, "service", &search.ServiceArgs{
 * 			DisableLocalAuth:  pulumi.Bool(true),
 * 			HostingMode:       search.HostingModeDefault,
 * 			Location:          pulumi.String("westus"),
 * 			PartitionCount:    pulumi.Int(1),
 * 			ReplicaCount:      pulumi.Int(3),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SearchServiceName: pulumi.String("mysearchservice"),
 * 			Sku: &search.SkuArgs{
 * 				Name: search.SkuNameStandard,
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"app-name": pulumi.String("My e-commerce app"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.search.Service;
 * import com.pulumi.azurenative.search.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .disableLocalAuth(true)
 *             .hostingMode("default")
 *             .location("westus")
 *             .partitionCount(1)
 *             .replicaCount(3)
 *             .resourceGroupName("rg1")
 *             .searchServiceName("mysearchservice")
 *             .sku(Map.of("name", "standard"))
 *             .tags(Map.of("app-name", "My e-commerce app"))
 *             .build());
 *     }
 * }
 * ```
 * ### SearchCreateOrUpdateServiceToAllowAccessFromPrivateEndpoints
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.Search.Service("service", new()
 *     {
 *         HostingMode = AzureNative.Search.HostingMode.Default,
 *         Location = "westus",
 *         PartitionCount = 1,
 *         PublicNetworkAccess = AzureNative.Search.PublicNetworkAccess.Disabled,
 *         ReplicaCount = 3,
 *         ResourceGroupName = "rg1",
 *         SearchServiceName = "mysearchservice",
 *         Sku = new AzureNative.Search.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Search.SkuName.Standard,
 *         },
 *         Tags =
 *         {
 *             { "app-name", "My e-commerce app" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/search/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := search.NewService(ctx, "service", &search.ServiceArgs{
 * 			HostingMode:         search.HostingModeDefault,
 * 			Location:            pulumi.String("westus"),
 * 			PartitionCount:      pulumi.Int(1),
 * 			PublicNetworkAccess: search.PublicNetworkAccessDisabled,
 * 			ReplicaCount:        pulumi.Int(3),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			SearchServiceName:   pulumi.String("mysearchservice"),
 * 			Sku: &search.SkuArgs{
 * 				Name: search.SkuNameStandard,
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"app-name": pulumi.String("My e-commerce app"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.search.Service;
 * import com.pulumi.azurenative.search.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .hostingMode("default")
 *             .location("westus")
 *             .partitionCount(1)
 *             .publicNetworkAccess("disabled")
 *             .replicaCount(3)
 *             .resourceGroupName("rg1")
 *             .searchServiceName("mysearchservice")
 *             .sku(Map.of("name", "standard"))
 *             .tags(Map.of("app-name", "My e-commerce app"))
 *             .build());
 *     }
 * }
 * ```
 * ### SearchCreateOrUpdateServiceToAllowAccessFromPublicCustomIPs
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.Search.Service("service", new()
 *     {
 *         HostingMode = AzureNative.Search.HostingMode.Default,
 *         Location = "westus",
 *         NetworkRuleSet = new AzureNative.Search.Inputs.NetworkRuleSetArgs
 *         {
 *             IpRules = new[]
 *             {
 *                 new AzureNative.Search.Inputs.IpRuleArgs
 *                 {
 *                     Value = "123.4.5.6",
 *                 },
 *                 new AzureNative.Search.Inputs.IpRuleArgs
 *                 {
 *                     Value = "123.4.6.0/18",
 *                 },
 *             },
 *         },
 *         PartitionCount = 1,
 *         ReplicaCount = 1,
 *         ResourceGroupName = "rg1",
 *         SearchServiceName = "mysearchservice",
 *         Sku = new AzureNative.Search.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Search.SkuName.Standard,
 *         },
 *         Tags =
 *         {
 *             { "app-name", "My e-commerce app" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/search/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := search.NewService(ctx, "service", &search.ServiceArgs{
 * 			HostingMode: search.HostingModeDefault,
 * 			Location:    pulumi.String("westus"),
 * 			NetworkRuleSet: search.NetworkRuleSetResponse{
 * 				IpRules: search.IpRuleArray{
 * 					&search.IpRuleArgs{
 * 						Value: pulumi.String("123.4.5.6"),
 * 					},
 * 					&search.IpRuleArgs{
 * 						Value: pulumi.String("123.4.6.0/18"),
 * 					},
 * 				},
 * 			},
 * 			PartitionCount:    pulumi.Int(1),
 * 			ReplicaCount:      pulumi.Int(1),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SearchServiceName: pulumi.String("mysearchservice"),
 * 			Sku: &search.SkuArgs{
 * 				Name: search.SkuNameStandard,
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"app-name": pulumi.String("My e-commerce app"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.search.Service;
 * import com.pulumi.azurenative.search.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .hostingMode("default")
 *             .location("westus")
 *             .networkRuleSet(Map.of("ipRules",
 *                 Map.of("value", "123.4.5.6"),
 *                 Map.of("value", "123.4.6.0/18")))
 *             .partitionCount(1)
 *             .replicaCount(1)
 *             .resourceGroupName("rg1")
 *             .searchServiceName("mysearchservice")
 *             .sku(Map.of("name", "standard"))
 *             .tags(Map.of("app-name", "My e-commerce app"))
 *             .build());
 *     }
 * }
 * ```
 * ### SearchCreateOrUpdateServiceWithCmkEnforcement
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.Search.Service("service", new()
 *     {
 *         EncryptionWithCmk = new AzureNative.Search.Inputs.EncryptionWithCmkArgs
 *         {
 *             Enforcement = AzureNative.Search.SearchEncryptionWithCmk.Enabled,
 *         },
 *         HostingMode = AzureNative.Search.HostingMode.Default,
 *         Location = "westus",
 *         PartitionCount = 1,
 *         ReplicaCount = 3,
 *         ResourceGroupName = "rg1",
 *         SearchServiceName = "mysearchservice",
 *         Sku = new AzureNative.Search.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Search.SkuName.Standard,
 *         },
 *         Tags =
 *         {
 *             { "app-name", "My e-commerce app" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/search/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := search.NewService(ctx, "service", &search.ServiceArgs{
 * 			EncryptionWithCmk: &search.EncryptionWithCmkArgs{
 * 				Enforcement: search.SearchEncryptionWithCmkEnabled,
 * 			},
 * 			HostingMode:       search.HostingModeDefault,
 * 			Location:          pulumi.String("westus"),
 * 			PartitionCount:    pulumi.Int(1),
 * 			ReplicaCount:      pulumi.Int(3),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SearchServiceName: pulumi.String("mysearchservice"),
 * 			Sku: &search.SkuArgs{
 * 				Name: search.SkuNameStandard,
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"app-name": pulumi.String("My e-commerce app"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.search.Service;
 * import com.pulumi.azurenative.search.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .encryptionWithCmk(Map.of("enforcement", "Enabled"))
 *             .hostingMode("default")
 *             .location("westus")
 *             .partitionCount(1)
 *             .replicaCount(3)
 *             .resourceGroupName("rg1")
 *             .searchServiceName("mysearchservice")
 *             .sku(Map.of("name", "standard"))
 *             .tags(Map.of("app-name", "My e-commerce app"))
 *             .build());
 *     }
 * }
 * ```
 * ### SearchCreateOrUpdateServiceWithIdentity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.Search.Service("service", new()
 *     {
 *         HostingMode = AzureNative.Search.HostingMode.Default,
 *         Identity = new AzureNative.Search.Inputs.IdentityArgs
 *         {
 *             Type = AzureNative.Search.IdentityType.SystemAssigned,
 *         },
 *         Location = "westus",
 *         PartitionCount = 1,
 *         ReplicaCount = 3,
 *         ResourceGroupName = "rg1",
 *         SearchServiceName = "mysearchservice",
 *         Sku = new AzureNative.Search.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Search.SkuName.Standard,
 *         },
 *         Tags =
 *         {
 *             { "app-name", "My e-commerce app" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/search/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := search.NewService(ctx, "service", &search.ServiceArgs{
 * 			HostingMode: search.HostingModeDefault,
 * 			Identity: &search.IdentityArgs{
 * 				Type: search.IdentityTypeSystemAssigned,
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			PartitionCount:    pulumi.Int(1),
 * 			ReplicaCount:      pulumi.Int(3),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SearchServiceName: pulumi.String("mysearchservice"),
 * 			Sku: &search.SkuArgs{
 * 				Name: search.SkuNameStandard,
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"app-name": pulumi.String("My e-commerce app"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.search.Service;
 * import com.pulumi.azurenative.search.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .hostingMode("default")
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .location("westus")
 *             .partitionCount(1)
 *             .replicaCount(3)
 *             .resourceGroupName("rg1")
 *             .searchServiceName("mysearchservice")
 *             .sku(Map.of("name", "standard"))
 *             .tags(Map.of("app-name", "My e-commerce app"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:search:Service mysearchservice /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}
 * ```
 * @property authOptions Defines the options for how the data plane API of a search service authenticates requests. This cannot be set if 'disableLocalAuth' is set to true.
 * @property disableLocalAuth When set to true, calls to the search service will not be permitted to utilize API keys for authentication. This cannot be set to true if 'dataPlaneAuthOptions' are defined.
 * @property encryptionWithCmk Specifies any policy regarding encryption of resources (such as indexes) using customer manager keys within a search service.
 * @property hostingMode Applicable only for the standard3 SKU. You can set this property to enable up to 3 high density partitions that allow up to 1000 indexes, which is much higher than the maximum indexes allowed for any other SKU. For the standard3 SKU, the value is either 'default' or 'highDensity'. For all other SKUs, this value must be 'default'.
 * @property identity The identity of the resource.
 * @property location The geo-location where the resource lives
 * @property networkRuleSet Network specific rules that determine how the Azure Cognitive Search service may be reached.
 * @property partitionCount The number of partitions in the search service; if specified, it can be 1, 2, 3, 4, 6, or 12. Values greater than 1 are only valid for standard SKUs. For 'standard3' services with hostingMode set to 'highDensity', the allowed values are between 1 and 3.
 * @property publicNetworkAccess This value can be set to 'enabled' to avoid breaking changes on existing customer resources and templates. If set to 'disabled', traffic over public interface is not allowed, and private endpoint connections would be the exclusive access method.
 * @property replicaCount The number of replicas in the search service. If specified, it must be a value between 1 and 12 inclusive for standard SKUs or between 1 and 3 inclusive for basic SKU.
 * @property resourceGroupName The name of the resource group within the current subscription. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property searchServiceName The name of the Azure Cognitive Search service to create or update. Search service names must only contain lowercase letters, digits or dashes, cannot use dash as the first two or last one characters, cannot contain consecutive dashes, and must be between 2 and 60 characters in length. Search service names must be globally unique since they are part of the service URI (https://<name>.search.windows.net). You cannot change the service name after the service is created.
 * @property sku The SKU of the Search Service, which determines price tier and capacity limits. This property is required when creating a new Search Service.
 * @property tags Resource tags.
 */
public data class ServiceArgs(
    public val authOptions: Output<DataPlaneAuthOptionsArgs>? = null,
    public val disableLocalAuth: Output<Boolean>? = null,
    public val encryptionWithCmk: Output<EncryptionWithCmkArgs>? = null,
    public val hostingMode: Output<HostingMode>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val networkRuleSet: Output<NetworkRuleSetArgs>? = null,
    public val partitionCount: Output<Int>? = null,
    public val publicNetworkAccess: Output<PublicNetworkAccess>? = null,
    public val replicaCount: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val searchServiceName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.search.ServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.search.ServiceArgs =
        com.pulumi.azurenative.search.ServiceArgs.builder()
            .authOptions(authOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .disableLocalAuth(disableLocalAuth?.applyValue({ args0 -> args0 }))
            .encryptionWithCmk(encryptionWithCmk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hostingMode(hostingMode?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkRuleSet(networkRuleSet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .partitionCount(partitionCount?.applyValue({ args0 -> args0 }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .replicaCount(replicaCount?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .searchServiceName(searchServiceName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ServiceArgs].
 */
@PulumiTagMarker
public class ServiceArgsBuilder internal constructor() {
    private var authOptions: Output<DataPlaneAuthOptionsArgs>? = null

    private var disableLocalAuth: Output<Boolean>? = null

    private var encryptionWithCmk: Output<EncryptionWithCmkArgs>? = null

    private var hostingMode: Output<HostingMode>? = null

    private var identity: Output<IdentityArgs>? = null

    private var location: Output<String>? = null

    private var networkRuleSet: Output<NetworkRuleSetArgs>? = null

    private var partitionCount: Output<Int>? = null

    private var publicNetworkAccess: Output<PublicNetworkAccess>? = null

    private var replicaCount: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var searchServiceName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Defines the options for how the data plane API of a search service authenticates requests. This cannot be set if 'disableLocalAuth' is set to true.
     */
    @JvmName("raxhlckulevpwgua")
    public suspend fun authOptions(`value`: Output<DataPlaneAuthOptionsArgs>) {
        this.authOptions = value
    }

    /**
     * @param value When set to true, calls to the search service will not be permitted to utilize API keys for authentication. This cannot be set to true if 'dataPlaneAuthOptions' are defined.
     */
    @JvmName("wmllblhboxkaxbvu")
    public suspend fun disableLocalAuth(`value`: Output<Boolean>) {
        this.disableLocalAuth = value
    }

    /**
     * @param value Specifies any policy regarding encryption of resources (such as indexes) using customer manager keys within a search service.
     */
    @JvmName("lcsnbnoicmjfefml")
    public suspend fun encryptionWithCmk(`value`: Output<EncryptionWithCmkArgs>) {
        this.encryptionWithCmk = value
    }

    /**
     * @param value Applicable only for the standard3 SKU. You can set this property to enable up to 3 high density partitions that allow up to 1000 indexes, which is much higher than the maximum indexes allowed for any other SKU. For the standard3 SKU, the value is either 'default' or 'highDensity'. For all other SKUs, this value must be 'default'.
     */
    @JvmName("fsnighiwbsapwcrx")
    public suspend fun hostingMode(`value`: Output<HostingMode>) {
        this.hostingMode = value
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("vklnlfkvnusxymok")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ywrrnbexssxgacou")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Network specific rules that determine how the Azure Cognitive Search service may be reached.
     */
    @JvmName("qiaxqejukxppruxw")
    public suspend fun networkRuleSet(`value`: Output<NetworkRuleSetArgs>) {
        this.networkRuleSet = value
    }

    /**
     * @param value The number of partitions in the search service; if specified, it can be 1, 2, 3, 4, 6, or 12. Values greater than 1 are only valid for standard SKUs. For 'standard3' services with hostingMode set to 'highDensity', the allowed values are between 1 and 3.
     */
    @JvmName("flumwnbynffvlimr")
    public suspend fun partitionCount(`value`: Output<Int>) {
        this.partitionCount = value
    }

    /**
     * @param value This value can be set to 'enabled' to avoid breaking changes on existing customer resources and templates. If set to 'disabled', traffic over public interface is not allowed, and private endpoint connections would be the exclusive access method.
     */
    @JvmName("qubptkwtnygixrio")
    public suspend fun publicNetworkAccess(`value`: Output<PublicNetworkAccess>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The number of replicas in the search service. If specified, it must be a value between 1 and 12 inclusive for standard SKUs or between 1 and 3 inclusive for basic SKU.
     */
    @JvmName("wkltkksqvdvkilxy")
    public suspend fun replicaCount(`value`: Output<Int>) {
        this.replicaCount = value
    }

    /**
     * @param value The name of the resource group within the current subscription. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("vtfnvygfinbvwfmf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Azure Cognitive Search service to create or update. Search service names must only contain lowercase letters, digits or dashes, cannot use dash as the first two or last one characters, cannot contain consecutive dashes, and must be between 2 and 60 characters in length. Search service names must be globally unique since they are part of the service URI (https://<name>.search.windows.net). You cannot change the service name after the service is created.
     */
    @JvmName("vksdsfevpfbhoggg")
    public suspend fun searchServiceName(`value`: Output<String>) {
        this.searchServiceName = value
    }

    /**
     * @param value The SKU of the Search Service, which determines price tier and capacity limits. This property is required when creating a new Search Service.
     */
    @JvmName("rmswoxuexcifbdeg")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("altdoseixulfawjb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Defines the options for how the data plane API of a search service authenticates requests. This cannot be set if 'disableLocalAuth' is set to true.
     */
    @JvmName("pwqcncaktsncywfh")
    public suspend fun authOptions(`value`: DataPlaneAuthOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authOptions = mapped
    }

    /**
     * @param argument Defines the options for how the data plane API of a search service authenticates requests. This cannot be set if 'disableLocalAuth' is set to true.
     */
    @JvmName("pijmxxpvehrreduo")
    public suspend fun authOptions(argument: suspend DataPlaneAuthOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = DataPlaneAuthOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authOptions = mapped
    }

    /**
     * @param value When set to true, calls to the search service will not be permitted to utilize API keys for authentication. This cannot be set to true if 'dataPlaneAuthOptions' are defined.
     */
    @JvmName("xqujupkeryuurtlh")
    public suspend fun disableLocalAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAuth = mapped
    }

    /**
     * @param value Specifies any policy regarding encryption of resources (such as indexes) using customer manager keys within a search service.
     */
    @JvmName("wjkaayunmfyoebgq")
    public suspend fun encryptionWithCmk(`value`: EncryptionWithCmkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionWithCmk = mapped
    }

    /**
     * @param argument Specifies any policy regarding encryption of resources (such as indexes) using customer manager keys within a search service.
     */
    @JvmName("twtixaalbifexevb")
    public suspend fun encryptionWithCmk(argument: suspend EncryptionWithCmkArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionWithCmkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionWithCmk = mapped
    }

    /**
     * @param value Applicable only for the standard3 SKU. You can set this property to enable up to 3 high density partitions that allow up to 1000 indexes, which is much higher than the maximum indexes allowed for any other SKU. For the standard3 SKU, the value is either 'default' or 'highDensity'. For all other SKUs, this value must be 'default'.
     */
    @JvmName("kqgggdtylebceyop")
    public suspend fun hostingMode(`value`: HostingMode?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostingMode = mapped
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("pvaafsunlhewqaiv")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the resource.
     */
    @JvmName("mybljgqowetowilo")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("plgmyyxylssakmkt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Network specific rules that determine how the Azure Cognitive Search service may be reached.
     */
    @JvmName("kpqngoykuhlxlbcp")
    public suspend fun networkRuleSet(`value`: NetworkRuleSetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkRuleSet = mapped
    }

    /**
     * @param argument Network specific rules that determine how the Azure Cognitive Search service may be reached.
     */
    @JvmName("iqncsmgopgcwwhim")
    public suspend fun networkRuleSet(argument: suspend NetworkRuleSetArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkRuleSetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkRuleSet = mapped
    }

    /**
     * @param value The number of partitions in the search service; if specified, it can be 1, 2, 3, 4, 6, or 12. Values greater than 1 are only valid for standard SKUs. For 'standard3' services with hostingMode set to 'highDensity', the allowed values are between 1 and 3.
     */
    @JvmName("acqwbhyqvvopvxuf")
    public suspend fun partitionCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionCount = mapped
    }

    /**
     * @param value This value can be set to 'enabled' to avoid breaking changes on existing customer resources and templates. If set to 'disabled', traffic over public interface is not allowed, and private endpoint connections would be the exclusive access method.
     */
    @JvmName("jfwhgksarwdtpabt")
    public suspend fun publicNetworkAccess(`value`: PublicNetworkAccess?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The number of replicas in the search service. If specified, it must be a value between 1 and 12 inclusive for standard SKUs or between 1 and 3 inclusive for basic SKU.
     */
    @JvmName("bmpmnklpvbgdqeal")
    public suspend fun replicaCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicaCount = mapped
    }

    /**
     * @param value The name of the resource group within the current subscription. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("qbsexnvdwepbxoet")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Azure Cognitive Search service to create or update. Search service names must only contain lowercase letters, digits or dashes, cannot use dash as the first two or last one characters, cannot contain consecutive dashes, and must be between 2 and 60 characters in length. Search service names must be globally unique since they are part of the service URI (https://<name>.search.windows.net). You cannot change the service name after the service is created.
     */
    @JvmName("pbnclbmjdiuvvxab")
    public suspend fun searchServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searchServiceName = mapped
    }

    /**
     * @param value The SKU of the Search Service, which determines price tier and capacity limits. This property is required when creating a new Search Service.
     */
    @JvmName("dukmklfhfxvxhetj")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU of the Search Service, which determines price tier and capacity limits. This property is required when creating a new Search Service.
     */
    @JvmName("ltdraemndsrhkbgc")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nfroyndfyuwdyhsp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("xubewuoxnddvplii")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ServiceArgs = ServiceArgs(
        authOptions = authOptions,
        disableLocalAuth = disableLocalAuth,
        encryptionWithCmk = encryptionWithCmk,
        hostingMode = hostingMode,
        identity = identity,
        location = location,
        networkRuleSet = networkRuleSet,
        partitionCount = partitionCount,
        publicNetworkAccess = publicNetworkAccess,
        replicaCount = replicaCount,
        resourceGroupName = resourceGroupName,
        searchServiceName = searchServiceName,
        sku = sku,
        tags = tags,
    )
}
