@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Describes what response the data plane API of a Search service would send for requests that failed authentication.
 */
public enum class AadAuthFailureMode(
    public val javaValue: com.pulumi.azurenative.search.enums.AadAuthFailureMode,
) : ConvertibleToJava<com.pulumi.azurenative.search.enums.AadAuthFailureMode> {
    /**
     * Indicates that requests that failed authentication should be presented with an HTTP status code of 403 (Forbidden).
     */
    Http403(com.pulumi.azurenative.search.enums.AadAuthFailureMode.Http403),

    /**
     * Indicates that requests that failed authentication should be presented with an HTTP status code of 401 (Unauthorized) and present a Bearer Challenge.
     */
    Http401WithBearerChallenge(com.pulumi.azurenative.search.enums.AadAuthFailureMode.Http401WithBearerChallenge),
    ;

    override fun toJava(): com.pulumi.azurenative.search.enums.AadAuthFailureMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.search.enums.AadAuthFailureMode):
            AadAuthFailureMode = AadAuthFailureMode.values().first { it.javaValue == javaType }
    }
}
