@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Describes how a search service should enforce having one or more non customer encrypted resources.
 */
public enum class SearchEncryptionWithCmk(
    public val javaValue: com.pulumi.azurenative.search.enums.SearchEncryptionWithCmk,
) : ConvertibleToJava<com.pulumi.azurenative.search.enums.SearchEncryptionWithCmk> {
    /**
     * No enforcement will be made and the search service can have non customer encrypted resources.
     */
    Disabled(com.pulumi.azurenative.search.enums.SearchEncryptionWithCmk.Disabled),

    /**
     * Search service will be marked as non-compliant if there are one or more non customer encrypted resources.
     */
    Enabled(com.pulumi.azurenative.search.enums.SearchEncryptionWithCmk.Enabled),

    /**
     * Enforcement policy is not explicitly specified, with the behavior being the same as if it were set to 'Disabled'.
     */
    Unspecified(com.pulumi.azurenative.search.enums.SearchEncryptionWithCmk.Unspecified),
    ;

    override fun toJava(): com.pulumi.azurenative.search.enums.SearchEncryptionWithCmk = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.search.enums.SearchEncryptionWithCmk):
            SearchEncryptionWithCmk =
            SearchEncryptionWithCmk.values().first { it.javaValue == javaType }
    }
}
