@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.inputs

import com.pulumi.azurenative.search.inputs.DataPlaneAadOrApiKeyAuthOptionArgs.builder
import com.pulumi.azurenative.search.kotlin.enums.AadAuthFailureMode
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Indicates that either the API key or an access token from Azure Active Directory can be used for authentication.
 * @property aadAuthFailureMode Describes what response the data plane API of a Search service would send for requests that failed authentication.
 */
public data class DataPlaneAadOrApiKeyAuthOptionArgs(
    public val aadAuthFailureMode: Output<AadAuthFailureMode>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.search.inputs.DataPlaneAadOrApiKeyAuthOptionArgs> {
    override fun toJava(): com.pulumi.azurenative.search.inputs.DataPlaneAadOrApiKeyAuthOptionArgs =
        com.pulumi.azurenative.search.inputs.DataPlaneAadOrApiKeyAuthOptionArgs.builder()
            .aadAuthFailureMode(
                aadAuthFailureMode?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataPlaneAadOrApiKeyAuthOptionArgs].
 */
@PulumiTagMarker
public class DataPlaneAadOrApiKeyAuthOptionArgsBuilder internal constructor() {
    private var aadAuthFailureMode: Output<AadAuthFailureMode>? = null

    /**
     * @param value Describes what response the data plane API of a Search service would send for requests that failed authentication.
     */
    @JvmName("ypojcanjnyuqylwg")
    public suspend fun aadAuthFailureMode(`value`: Output<AadAuthFailureMode>) {
        this.aadAuthFailureMode = value
    }

    /**
     * @param value Describes what response the data plane API of a Search service would send for requests that failed authentication.
     */
    @JvmName("nsxhbhouwasgbhkk")
    public suspend fun aadAuthFailureMode(`value`: AadAuthFailureMode?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadAuthFailureMode = mapped
    }

    internal fun build(): DataPlaneAadOrApiKeyAuthOptionArgs = DataPlaneAadOrApiKeyAuthOptionArgs(
        aadAuthFailureMode = aadAuthFailureMode,
    )
}
