@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.inputs

import com.pulumi.azurenative.search.inputs.EncryptionWithCmkArgs.builder
import com.pulumi.azurenative.search.kotlin.enums.SearchEncryptionWithCmk
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a policy that determines how resources within the search service are to be encrypted with Customer Managed Keys.
 * @property enforcement Describes how a search service should enforce having one or more non customer encrypted resources.
 */
public data class EncryptionWithCmkArgs(
    public val enforcement: Output<SearchEncryptionWithCmk>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.search.inputs.EncryptionWithCmkArgs> {
    override fun toJava(): com.pulumi.azurenative.search.inputs.EncryptionWithCmkArgs =
        com.pulumi.azurenative.search.inputs.EncryptionWithCmkArgs.builder()
            .enforcement(enforcement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EncryptionWithCmkArgs].
 */
@PulumiTagMarker
public class EncryptionWithCmkArgsBuilder internal constructor() {
    private var enforcement: Output<SearchEncryptionWithCmk>? = null

    /**
     * @param value Describes how a search service should enforce having one or more non customer encrypted resources.
     */
    @JvmName("djwkyhtfhmvbfnlq")
    public suspend fun enforcement(`value`: Output<SearchEncryptionWithCmk>) {
        this.enforcement = value
    }

    /**
     * @param value Describes how a search service should enforce having one or more non customer encrypted resources.
     */
    @JvmName("nhaegbbrpldjptbr")
    public suspend fun enforcement(`value`: SearchEncryptionWithCmk?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforcement = mapped
    }

    internal fun build(): EncryptionWithCmkArgs = EncryptionWithCmkArgs(
        enforcement = enforcement,
    )
}
