@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.inputs

import com.pulumi.azurenative.search.inputs.PrivateEndpointConnectionPropertiesArgs.builder
import com.pulumi.azurenative.search.kotlin.enums.PrivateLinkServiceConnectionProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes the properties of an existing Private Endpoint connection to the Azure Cognitive Search service.
 * @property groupId The group id from the provider of resource the private link service connection is for.
 * @property privateEndpoint The private endpoint resource from Microsoft.Network provider.
 * @property privateLinkServiceConnectionState Describes the current state of an existing Private Link Service connection to the Azure Private Endpoint.
 * @property provisioningState The provisioning state of the private link service connection. Can be Updating, Deleting, Failed, Succeeded, or Incomplete
 */
public data class PrivateEndpointConnectionPropertiesArgs(
    public val groupId: Output<String>? = null,
    public val privateEndpoint: Output<PrivateEndpointConnectionPropertiesPrivateEndpointArgs>? =
        null,
    public val privateLinkServiceConnectionState:
    Output<PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionStateArgs>? = null,
    public val provisioningState:
    Output<Either<String, PrivateLinkServiceConnectionProvisioningState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.search.inputs.PrivateEndpointConnectionPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.search.inputs.PrivateEndpointConnectionPropertiesArgs =
        com.pulumi.azurenative.search.inputs.PrivateEndpointConnectionPropertiesArgs.builder()
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .privateEndpoint(privateEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [PrivateEndpointConnectionPropertiesArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionPropertiesArgsBuilder internal constructor() {
    private var groupId: Output<String>? = null

    private var privateEndpoint: Output<PrivateEndpointConnectionPropertiesPrivateEndpointArgs>? =
        null

    private var privateLinkServiceConnectionState:
        Output<PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionStateArgs>? = null

    private var provisioningState:
        Output<Either<String, PrivateLinkServiceConnectionProvisioningState>>? = null

    /**
     * @param value The group id from the provider of resource the private link service connection is for.
     */
    @JvmName("upvpxlslefxhjfct")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The private endpoint resource from Microsoft.Network provider.
     */
    @JvmName("oklrlkdvxybvsujj")
    public suspend
    fun privateEndpoint(`value`: Output<PrivateEndpointConnectionPropertiesPrivateEndpointArgs>) {
        this.privateEndpoint = value
    }

    /**
     * @param value Describes the current state of an existing Private Link Service connection to the Azure Private Endpoint.
     */
    @JvmName("obwfyyhueobgwllh")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The provisioning state of the private link service connection. Can be Updating, Deleting, Failed, Succeeded, or Incomplete
     */
    @JvmName("ifmonycgbftqsxxh")
    public suspend
    fun provisioningState(`value`: Output<Either<String, PrivateLinkServiceConnectionProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The group id from the provider of resource the private link service connection is for.
     */
    @JvmName("eqithmuhucqrfwwt")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The private endpoint resource from Microsoft.Network provider.
     */
    @JvmName("tfjfqdjersdtiryf")
    public suspend
    fun privateEndpoint(`value`: PrivateEndpointConnectionPropertiesPrivateEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpoint = mapped
    }

    /**
     * @param argument The private endpoint resource from Microsoft.Network provider.
     */
    @JvmName("mvtwqavqdyekdjsn")
    public suspend
    fun privateEndpoint(argument: suspend PrivateEndpointConnectionPropertiesPrivateEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointConnectionPropertiesPrivateEndpointArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateEndpoint = mapped
    }

    /**
     * @param value Describes the current state of an existing Private Link Service connection to the Azure Private Endpoint.
     */
    @JvmName("xpuuycpaptkcecwe")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument Describes the current state of an existing Private Link Service connection to the Azure Private Endpoint.
     */
    @JvmName("csxfivrdfygjgjbb")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped =
            PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value The provisioning state of the private link service connection. Can be Updating, Deleting, Failed, Succeeded, or Incomplete
     */
    @JvmName("elpluqlvsgvovwlb")
    public suspend
    fun provisioningState(`value`: Either<String, PrivateLinkServiceConnectionProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The provisioning state of the private link service connection. Can be Updating, Deleting, Failed, Succeeded, or Incomplete
     */
    @JvmName("vvpvbcydlysjknkn")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrivateLinkServiceConnectionProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The provisioning state of the private link service connection. Can be Updating, Deleting, Failed, Succeeded, or Incomplete
     */
    @JvmName("rmqmuimegrlstxbq")
    public fun provisioningState(`value`: PrivateLinkServiceConnectionProvisioningState) {
        val toBeMapped = Either.ofRight<String, PrivateLinkServiceConnectionProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    internal fun build(): PrivateEndpointConnectionPropertiesArgs =
        PrivateEndpointConnectionPropertiesArgs(
            groupId = groupId,
            privateEndpoint = privateEndpoint,
            privateLinkServiceConnectionState = privateLinkServiceConnectionState,
            provisioningState = provisioningState,
        )
}
