@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a policy that determines how resources within the search service are to be encrypted with Customer Managed Keys.
 * @property encryptionComplianceStatus Describes whether the search service is compliant or not with respect to having non customer encrypted resources. If a service has more than one non customer encrypted resource and 'Enforcement' is 'enabled' then the service will be marked as 'nonCompliant'.
 * @property enforcement Describes how a search service should enforce having one or more non customer encrypted resources.
 */
public data class EncryptionWithCmkResponse(
    public val encryptionComplianceStatus: String,
    public val enforcement: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.search.outputs.EncryptionWithCmkResponse):
            EncryptionWithCmkResponse = EncryptionWithCmkResponse(
            encryptionComplianceStatus = javaType.encryptionComplianceStatus(),
            enforcement = javaType.enforcement().map({ args0 -> args0 }).orElse(null),
        )
    }
}
