@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Describes an Azure Cognitive Search service and its current state.
 * @property authOptions Defines the options for how the data plane API of a search service authenticates requests. This cannot be set if 'disableLocalAuth' is set to true.
 * @property disableLocalAuth When set to true, calls to the search service will not be permitted to utilize API keys for authentication. This cannot be set to true if 'dataPlaneAuthOptions' are defined.
 * @property encryptionWithCmk Specifies any policy regarding encryption of resources (such as indexes) using customer manager keys within a search service.
 * @property hostingMode Applicable only for the standard3 SKU. You can set this property to enable up to 3 high density partitions that allow up to 1000 indexes, which is much higher than the maximum indexes allowed for any other SKU. For the standard3 SKU, the value is either 'default' or 'highDensity'. For all other SKUs, this value must be 'default'.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The identity of the resource.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property networkRuleSet Network specific rules that determine how the Azure Cognitive Search service may be reached.
 * @property partitionCount The number of partitions in the search service; if specified, it can be 1, 2, 3, 4, 6, or 12. Values greater than 1 are only valid for standard SKUs. For 'standard3' services with hostingMode set to 'highDensity', the allowed values are between 1 and 3.
 * @property privateEndpointConnections The list of private endpoint connections to the Azure Cognitive Search service.
 * @property provisioningState The state of the last provisioning operation performed on the search service. Provisioning is an intermediate state that occurs while service capacity is being established. After capacity is set up, provisioningState changes to either 'succeeded' or 'failed'. Client applications can poll provisioning status (the recommended polling interval is from 30 seconds to one minute) by using the Get Search Service operation to see when an operation is completed. If you are using the free service, this value tends to come back as 'succeeded' directly in the call to Create search service. This is because the free service uses capacity that is already set up.
 * @property publicNetworkAccess This value can be set to 'enabled' to avoid breaking changes on existing customer resources and templates. If set to 'disabled', traffic over public interface is not allowed, and private endpoint connections would be the exclusive access method.
 * @property replicaCount The number of replicas in the search service. If specified, it must be a value between 1 and 12 inclusive for standard SKUs or between 1 and 3 inclusive for basic SKU.
 * @property sharedPrivateLinkResources The list of shared private link resources managed by the Azure Cognitive Search service.
 * @property sku The SKU of the Search Service, which determines price tier and capacity limits. This property is required when creating a new Search Service.
 * @property status The status of the search service. Possible values include: 'running': The search service is running and no provisioning operations are underway. 'provisioning': The search service is being provisioned or scaled up or down. 'deleting': The search service is being deleted. 'degraded': The search service is degraded. This can occur when the underlying search units are not healthy. The search service is most likely operational, but performance might be slow and some requests might be dropped. 'disabled': The search service is disabled. In this state, the service will reject all API requests. 'error': The search service is in an error state. If your service is in the degraded, disabled, or error states, it means the Azure Cognitive Search team is actively investigating the underlying issue. Dedicated services in these states are still chargeable based on the number of search units provisioned.
 * @property statusDetails The details of the search service status.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetServiceResult(
    public val authOptions: DataPlaneAuthOptionsResponse? = null,
    public val disableLocalAuth: Boolean? = null,
    public val encryptionWithCmk: EncryptionWithCmkResponse? = null,
    public val hostingMode: String? = null,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val location: String,
    public val name: String,
    public val networkRuleSet: NetworkRuleSetResponse? = null,
    public val partitionCount: Int? = null,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val replicaCount: Int? = null,
    public val sharedPrivateLinkResources: List<SharedPrivateLinkResourceResponse>,
    public val sku: SkuResponse? = null,
    public val status: String,
    public val statusDetails: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.search.outputs.GetServiceResult):
            GetServiceResult = GetServiceResult(
            authOptions = javaType.authOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.search.kotlin.outputs.DataPlaneAuthOptionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            disableLocalAuth = javaType.disableLocalAuth().map({ args0 -> args0 }).orElse(null),
            encryptionWithCmk = javaType.encryptionWithCmk().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.search.kotlin.outputs.EncryptionWithCmkResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hostingMode = javaType.hostingMode().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.search.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            networkRuleSet = javaType.networkRuleSet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.search.kotlin.outputs.NetworkRuleSetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            partitionCount = javaType.partitionCount().map({ args0 -> args0 }).orElse(null),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.search.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            replicaCount = javaType.replicaCount().map({ args0 -> args0 }).orElse(null),
            sharedPrivateLinkResources = javaType.sharedPrivateLinkResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.search.kotlin.outputs.SharedPrivateLinkResourceResponse.Companion.toKotlin(args0)
                })
            }),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.search.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status(),
            statusDetails = javaType.statusDetails(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
