@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Network specific rules that determine how the Azure Cognitive Search service may be reached.
 * @property ipRules A list of IP restriction rules that defines the inbound network(s) with allowing access to the search service endpoint. At the meantime, all other public IP networks are blocked by the firewall. These restriction rules are applied only when the 'publicNetworkAccess' of the search service is 'enabled'; otherwise, traffic over public interface is not allowed even with any public IP rules, and private endpoint connections would be the exclusive access method.
 */
public data class NetworkRuleSetResponse(
    public val ipRules: List<IpRuleResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.search.outputs.NetworkRuleSetResponse):
            NetworkRuleSetResponse = NetworkRuleSetResponse(
            ipRules = javaType.ipRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.search.kotlin.outputs.IpRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
