@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.AssessmentMetadataInSubscriptionArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.AssessmentType
import com.pulumi.azurenative.security.kotlin.enums.Categories
import com.pulumi.azurenative.security.kotlin.enums.ImplementationEffort
import com.pulumi.azurenative.security.kotlin.enums.Severity
import com.pulumi.azurenative.security.kotlin.enums.Tactics
import com.pulumi.azurenative.security.kotlin.enums.Techniques
import com.pulumi.azurenative.security.kotlin.enums.Threats
import com.pulumi.azurenative.security.kotlin.enums.UserImpact
import com.pulumi.azurenative.security.kotlin.inputs.SecurityAssessmentMetadataPartnerDataArgs
import com.pulumi.azurenative.security.kotlin.inputs.SecurityAssessmentMetadataPartnerDataArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.SecurityAssessmentMetadataPropertiesResponsePublishDatesArgs
import com.pulumi.azurenative.security.kotlin.inputs.SecurityAssessmentMetadataPropertiesResponsePublishDatesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Security assessment metadata response
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * ## Example Usage
 * ### Create security assessment metadata for subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assessmentMetadataInSubscription = new AzureNative.Security.AssessmentMetadataInSubscription("assessmentMetadataInSubscription", new()
 *     {
 *         AssessmentMetadataName = "ca039e75-a276-4175-aebc-bcd41e4b14b7",
 *         AssessmentType = "CustomerManaged",
 *         Categories = new[]
 *         {
 *             "Compute",
 *         },
 *         Description = "Install an endpoint protection solution on your virtual machines scale sets, to protect them from threats and vulnerabilities.",
 *         DisplayName = "Install endpoint protection solution on virtual machine scale sets",
 *         ImplementationEffort = "Low",
 *         RemediationDescription = "To install an endpoint protection solution: 1.  <a href=\"https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-faq#how-do-i-turn-on-antimalware-in-my-virtual-machine-scale-set\">Follow the instructions in How do I turn on antimalware in my virtual machine scale set</a>",
 *         Severity = "Medium",
 *         Threats = new[]
 *         {
 *             "dataExfiltration",
 *             "dataSpillage",
 *             "maliciousInsider",
 *         },
 *         UserImpact = "Low",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAssessmentMetadataInSubscription(ctx, "assessmentMetadataInSubscription", &security.AssessmentMetadataInSubscriptionArgs{
 * 			AssessmentMetadataName: pulumi.String("ca039e75-a276-4175-aebc-bcd41e4b14b7"),
 * 			AssessmentType:         pulumi.String("CustomerManaged"),
 * 			Categories: pulumi.StringArray{
 * 				pulumi.String("Compute"),
 * 			},
 * 			Description:            pulumi.String("Install an endpoint protection solution on your virtual machines scale sets, to protect them from threats and vulnerabilities."),
 * 			DisplayName:            pulumi.String("Install endpoint protection solution on virtual machine scale sets"),
 * 			ImplementationEffort:   pulumi.String("Low"),
 * 			RemediationDescription: pulumi.String("To install an endpoint protection solution: 1.  <a href=\"https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-faq#how-do-i-turn-on-antimalware-in-my-virtual-machine-scale-set\">Follow the instructions in How do I turn on antimalware in my virtual machine scale set</a>"),
 * 			Severity:               pulumi.String("Medium"),
 * 			Threats: pulumi.StringArray{
 * 				pulumi.String("dataExfiltration"),
 * 				pulumi.String("dataSpillage"),
 * 				pulumi.String("maliciousInsider"),
 * 			},
 * 			UserImpact: pulumi.String("Low"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.AssessmentMetadataInSubscription;
 * import com.pulumi.azurenative.security.AssessmentMetadataInSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assessmentMetadataInSubscription = new AssessmentMetadataInSubscription("assessmentMetadataInSubscription", AssessmentMetadataInSubscriptionArgs.builder()
 *             .assessmentMetadataName("ca039e75-a276-4175-aebc-bcd41e4b14b7")
 *             .assessmentType("CustomerManaged")
 *             .categories("Compute")
 *             .description("Install an endpoint protection solution on your virtual machines scale sets, to protect them from threats and vulnerabilities.")
 *             .displayName("Install endpoint protection solution on virtual machine scale sets")
 *             .implementationEffort("Low")
 *             .remediationDescription("To install an endpoint protection solution: 1.  <a href=\"https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-faq#how-do-i-turn-on-antimalware-in-my-virtual-machine-scale-set\">Follow the instructions in How do I turn on antimalware in my virtual machine scale set</a>")
 *             .severity("Medium")
 *             .threats(
 *                 "dataExfiltration",
 *                 "dataSpillage",
 *                 "maliciousInsider")
 *             .userImpact("Low")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:AssessmentMetadataInSubscription ca039e75-a276-4175-aebc-bcd41e4b14b7 /subscriptions/{subscriptionId}/providers/Microsoft.Security/assessmentMetadata/{assessmentMetadataName}
 * ```
 * @property assessmentMetadataName The Assessment Key - Unique key for the assessment type
 * @property assessmentType BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
 * @property categories
 * @property description Human readable description of the assessment
 * @property displayName User friendly display name of the assessment
 * @property implementationEffort The implementation effort required to remediate this assessment
 * @property partnerData Describes the partner that created the assessment
 * @property plannedDeprecationDate
 * @property preview True if this assessment is in preview release status
 * @property publishDates
 * @property remediationDescription Human readable description of what you should do to mitigate this security issue
 * @property severity The severity level of the assessment
 * @property tactics
 * @property techniques
 * @property threats
 * @property userImpact The user impact of the assessment
 */
public data class AssessmentMetadataInSubscriptionArgs(
    public val assessmentMetadataName: Output<String>? = null,
    public val assessmentType: Output<Either<String, AssessmentType>>? = null,
    public val categories: Output<List<Either<String, Categories>>>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val implementationEffort: Output<Either<String, ImplementationEffort>>? = null,
    public val partnerData: Output<SecurityAssessmentMetadataPartnerDataArgs>? = null,
    public val plannedDeprecationDate: Output<String>? = null,
    public val preview: Output<Boolean>? = null,
    public val publishDates: Output<SecurityAssessmentMetadataPropertiesResponsePublishDatesArgs>? =
        null,
    public val remediationDescription: Output<String>? = null,
    public val severity: Output<Either<String, Severity>>? = null,
    public val tactics: Output<List<Either<String, Tactics>>>? = null,
    public val techniques: Output<List<Either<String, Techniques>>>? = null,
    public val threats: Output<List<Either<String, Threats>>>? = null,
    public val userImpact: Output<Either<String, UserImpact>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.AssessmentMetadataInSubscriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.security.AssessmentMetadataInSubscriptionArgs =
        com.pulumi.azurenative.security.AssessmentMetadataInSubscriptionArgs.builder()
            .assessmentMetadataName(assessmentMetadataName?.applyValue({ args0 -> args0 }))
            .assessmentType(
                assessmentType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .categories(
                categories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .implementationEffort(
                implementationEffort?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .partnerData(partnerData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .plannedDeprecationDate(plannedDeprecationDate?.applyValue({ args0 -> args0 }))
            .preview(preview?.applyValue({ args0 -> args0 }))
            .publishDates(publishDates?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .remediationDescription(remediationDescription?.applyValue({ args0 -> args0 }))
            .severity(
                severity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tactics(
                tactics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .techniques(
                techniques?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .threats(
                threats?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .userImpact(
                userImpact?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AssessmentMetadataInSubscriptionArgs].
 */
@PulumiTagMarker
public class AssessmentMetadataInSubscriptionArgsBuilder internal constructor() {
    private var assessmentMetadataName: Output<String>? = null

    private var assessmentType: Output<Either<String, AssessmentType>>? = null

    private var categories: Output<List<Either<String, Categories>>>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var implementationEffort: Output<Either<String, ImplementationEffort>>? = null

    private var partnerData: Output<SecurityAssessmentMetadataPartnerDataArgs>? = null

    private var plannedDeprecationDate: Output<String>? = null

    private var preview: Output<Boolean>? = null

    private var publishDates: Output<SecurityAssessmentMetadataPropertiesResponsePublishDatesArgs>? =
        null

    private var remediationDescription: Output<String>? = null

    private var severity: Output<Either<String, Severity>>? = null

    private var tactics: Output<List<Either<String, Tactics>>>? = null

    private var techniques: Output<List<Either<String, Techniques>>>? = null

    private var threats: Output<List<Either<String, Threats>>>? = null

    private var userImpact: Output<Either<String, UserImpact>>? = null

    /**
     * @param value The Assessment Key - Unique key for the assessment type
     */
    @JvmName("cvlewtsbdruubvys")
    public suspend fun assessmentMetadataName(`value`: Output<String>) {
        this.assessmentMetadataName = value
    }

    /**
     * @param value BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
     */
    @JvmName("pfvsbowbbcsvwmtg")
    public suspend fun assessmentType(`value`: Output<Either<String, AssessmentType>>) {
        this.assessmentType = value
    }

    /**
     * @param value
     */
    @JvmName("vpfrnpqdlbidqqqa")
    public suspend fun categories(`value`: Output<List<Either<String, Categories>>>) {
        this.categories = value
    }

    @JvmName("arlmomacbdqlawvh")
    public suspend fun categories(vararg values: Output<Either<String, Categories>>) {
        this.categories = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("pvvocbwblfokhycp")
    public suspend fun categories(values: List<Output<Either<String, Categories>>>) {
        this.categories = Output.all(values)
    }

    /**
     * @param value Human readable description of the assessment
     */
    @JvmName("heaphoxxsclwookt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value User friendly display name of the assessment
     */
    @JvmName("ertjcrginpjkhyvk")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The implementation effort required to remediate this assessment
     */
    @JvmName("nlolgmsgungxbtil")
    public suspend fun implementationEffort(`value`: Output<Either<String, ImplementationEffort>>) {
        this.implementationEffort = value
    }

    /**
     * @param value Describes the partner that created the assessment
     */
    @JvmName("uwtykycesdvrydlj")
    public suspend fun partnerData(`value`: Output<SecurityAssessmentMetadataPartnerDataArgs>) {
        this.partnerData = value
    }

    /**
     * @param value
     */
    @JvmName("kemyamkivvobgcdk")
    public suspend fun plannedDeprecationDate(`value`: Output<String>) {
        this.plannedDeprecationDate = value
    }

    /**
     * @param value True if this assessment is in preview release status
     */
    @JvmName("hpigxcifjjbfwhxn")
    public suspend fun preview(`value`: Output<Boolean>) {
        this.preview = value
    }

    /**
     * @param value
     */
    @JvmName("lfwqpvdpbxredvjc")
    public suspend
    fun publishDates(`value`: Output<SecurityAssessmentMetadataPropertiesResponsePublishDatesArgs>) {
        this.publishDates = value
    }

    /**
     * @param value Human readable description of what you should do to mitigate this security issue
     */
    @JvmName("ykcqvwqxajfpoknl")
    public suspend fun remediationDescription(`value`: Output<String>) {
        this.remediationDescription = value
    }

    /**
     * @param value The severity level of the assessment
     */
    @JvmName("hsaythxuvtnpvtkj")
    public suspend fun severity(`value`: Output<Either<String, Severity>>) {
        this.severity = value
    }

    /**
     * @param value
     */
    @JvmName("nupyhvcofukpmyuw")
    public suspend fun tactics(`value`: Output<List<Either<String, Tactics>>>) {
        this.tactics = value
    }

    @JvmName("anaehsyrcxnowncm")
    public suspend fun tactics(vararg values: Output<Either<String, Tactics>>) {
        this.tactics = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("dyrtvcwscnfpddia")
    public suspend fun tactics(values: List<Output<Either<String, Tactics>>>) {
        this.tactics = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("fcasxtufdicqahgb")
    public suspend fun techniques(`value`: Output<List<Either<String, Techniques>>>) {
        this.techniques = value
    }

    @JvmName("gxvwrcerjanbewne")
    public suspend fun techniques(vararg values: Output<Either<String, Techniques>>) {
        this.techniques = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("qrewdnfmplosytmc")
    public suspend fun techniques(values: List<Output<Either<String, Techniques>>>) {
        this.techniques = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("quighqisvmbcdiab")
    public suspend fun threats(`value`: Output<List<Either<String, Threats>>>) {
        this.threats = value
    }

    @JvmName("xrnhhqdkweohjtya")
    public suspend fun threats(vararg values: Output<Either<String, Threats>>) {
        this.threats = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("hmgdxyddprbyyjuu")
    public suspend fun threats(values: List<Output<Either<String, Threats>>>) {
        this.threats = Output.all(values)
    }

    /**
     * @param value The user impact of the assessment
     */
    @JvmName("hmjnswypsbrhdujb")
    public suspend fun userImpact(`value`: Output<Either<String, UserImpact>>) {
        this.userImpact = value
    }

    /**
     * @param value The Assessment Key - Unique key for the assessment type
     */
    @JvmName("xskiofpkbcwgflni")
    public suspend fun assessmentMetadataName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentMetadataName = mapped
    }

    /**
     * @param value BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
     */
    @JvmName("revjrgjskfjfjfpa")
    public suspend fun assessmentType(`value`: Either<String, AssessmentType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentType = mapped
    }

    /**
     * @param value BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
     */
    @JvmName("dmgvvreaycbaafvu")
    public fun assessmentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssessmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assessmentType = mapped
    }

    /**
     * @param value BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
     */
    @JvmName("qswvkofhvhbawcnw")
    public fun assessmentType(`value`: AssessmentType) {
        val toBeMapped = Either.ofRight<String, AssessmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assessmentType = mapped
    }

    /**
     * @param value
     */
    @JvmName("dbrkkbbhwqrxlmpl")
    public suspend fun categories(`value`: List<Either<String, Categories>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.categories = mapped
    }

    /**
     * @param values
     */
    @JvmName("mchxugjbrtqchplr")
    public suspend fun categories(vararg values: Either<String, Categories>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.categories = mapped
    }

    /**
     * @param value Human readable description of the assessment
     */
    @JvmName("vostmpbmvrwqkrgn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value User friendly display name of the assessment
     */
    @JvmName("jgbnvmqfkpqdsqrk")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The implementation effort required to remediate this assessment
     */
    @JvmName("pqocskpaejfecyns")
    public suspend fun implementationEffort(`value`: Either<String, ImplementationEffort>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.implementationEffort = mapped
    }

    /**
     * @param value The implementation effort required to remediate this assessment
     */
    @JvmName("wmrjiucyrtmawhpq")
    public fun implementationEffort(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ImplementationEffort>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.implementationEffort = mapped
    }

    /**
     * @param value The implementation effort required to remediate this assessment
     */
    @JvmName("kwxlnhelotaprewn")
    public fun implementationEffort(`value`: ImplementationEffort) {
        val toBeMapped = Either.ofRight<String, ImplementationEffort>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.implementationEffort = mapped
    }

    /**
     * @param value Describes the partner that created the assessment
     */
    @JvmName("wutlobjiiecaocxn")
    public suspend fun partnerData(`value`: SecurityAssessmentMetadataPartnerDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerData = mapped
    }

    /**
     * @param argument Describes the partner that created the assessment
     */
    @JvmName("igbilvjuhmqeicdw")
    public suspend
    fun partnerData(argument: suspend SecurityAssessmentMetadataPartnerDataArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityAssessmentMetadataPartnerDataArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.partnerData = mapped
    }

    /**
     * @param value
     */
    @JvmName("ohimnrptetnxalqp")
    public suspend fun plannedDeprecationDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plannedDeprecationDate = mapped
    }

    /**
     * @param value True if this assessment is in preview release status
     */
    @JvmName("nnikglftmoyfpjas")
    public suspend fun preview(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preview = mapped
    }

    /**
     * @param value
     */
    @JvmName("oraigddtbgucahgg")
    public suspend
    fun publishDates(`value`: SecurityAssessmentMetadataPropertiesResponsePublishDatesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publishDates = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ptoatwdkmpvmwojh")
    public suspend
    fun publishDates(argument: suspend SecurityAssessmentMetadataPropertiesResponsePublishDatesArgsBuilder.() -> Unit) {
        val toBeMapped =
            SecurityAssessmentMetadataPropertiesResponsePublishDatesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.publishDates = mapped
    }

    /**
     * @param value Human readable description of what you should do to mitigate this security issue
     */
    @JvmName("wcmjufbfwfkmwdvv")
    public suspend fun remediationDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remediationDescription = mapped
    }

    /**
     * @param value The severity level of the assessment
     */
    @JvmName("qngwneumjdamfnvs")
    public suspend fun severity(`value`: Either<String, Severity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The severity level of the assessment
     */
    @JvmName("xduvogtoiwkppqxx")
    public fun severity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Severity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The severity level of the assessment
     */
    @JvmName("brnkeamimnveesyg")
    public fun severity(`value`: Severity) {
        val toBeMapped = Either.ofRight<String, Severity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value
     */
    @JvmName("upxdbkvvplayfuvj")
    public suspend fun tactics(`value`: List<Either<String, Tactics>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tactics = mapped
    }

    /**
     * @param values
     */
    @JvmName("bsyxdeqqadlduvlv")
    public suspend fun tactics(vararg values: Either<String, Tactics>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tactics = mapped
    }

    /**
     * @param value
     */
    @JvmName("npxfichxnxygywwl")
    public suspend fun techniques(`value`: List<Either<String, Techniques>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.techniques = mapped
    }

    /**
     * @param values
     */
    @JvmName("dhsyeexuvbhxfcjx")
    public suspend fun techniques(vararg values: Either<String, Techniques>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.techniques = mapped
    }

    /**
     * @param value
     */
    @JvmName("nokqfaqwnjrvbcch")
    public suspend fun threats(`value`: List<Either<String, Threats>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threats = mapped
    }

    /**
     * @param values
     */
    @JvmName("bxerdvwwkwouwxgl")
    public suspend fun threats(vararg values: Either<String, Threats>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threats = mapped
    }

    /**
     * @param value The user impact of the assessment
     */
    @JvmName("voofhpfikjvdtkjp")
    public suspend fun userImpact(`value`: Either<String, UserImpact>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userImpact = mapped
    }

    /**
     * @param value The user impact of the assessment
     */
    @JvmName("xqqjxnvhvnosayri")
    public fun userImpact(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UserImpact>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userImpact = mapped
    }

    /**
     * @param value The user impact of the assessment
     */
    @JvmName("wtnbnkobexnmpqft")
    public fun userImpact(`value`: UserImpact) {
        val toBeMapped = Either.ofRight<String, UserImpact>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userImpact = mapped
    }

    internal fun build(): AssessmentMetadataInSubscriptionArgs = AssessmentMetadataInSubscriptionArgs(
        assessmentMetadataName = assessmentMetadataName,
        assessmentType = assessmentType,
        categories = categories,
        description = description,
        displayName = displayName,
        implementationEffort = implementationEffort,
        partnerData = partnerData,
        plannedDeprecationDate = plannedDeprecationDate,
        preview = preview,
        publishDates = publishDates,
        remediationDescription = remediationDescription,
        severity = severity,
        tactics = tactics,
        techniques = techniques,
        threats = threats,
        userImpact = userImpact,
    )
}
