@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.AutomationScopeResponse
import com.pulumi.azurenative.security.kotlin.outputs.AutomationSourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.security.kotlin.outputs.AutomationScopeResponse.Companion.toKotlin as automationScopeResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.AutomationSourceResponse.Companion.toKotlin as automationSourceResponseToKotlin

/**
 * Builder for [Automation].
 */
@PulumiTagMarker
public class AutomationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AutomationArgs = AutomationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AutomationArgsBuilder.() -> Unit) {
        val builder = AutomationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Automation {
        val builtJavaResource = com.pulumi.azurenative.security.Automation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Automation(builtJavaResource)
    }
}

/**
 * The security automation resource.
 * Azure REST API version: 2019-01-01-preview. Prior API version in Azure Native 1.x: 2019-01-01-preview.
 * ## Example Usage
 * ### Create or update a security automation for all assessments (including all severities)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var automation = new AzureNative.Security.Automation("automation", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Security.Inputs.AutomationActionLogicAppArgs
 *             {
 *                 ActionType = "LogicApp",
 *                 LogicAppResourceId = "/subscriptions/e54a4a18-5b94-4f90-9471-bd3decad8a2e/resourceGroups/sample/providers/Microsoft.Logic/workflows/MyTest1",
 *                 Uri = "https://exampleTriggerUri1.com",
 *             },
 *         },
 *         AutomationName = "exampleAutomation",
 *         Description = "An example of a security automation that triggers one LogicApp resource (myTest1) on any security assessment",
 *         IsEnabled = true,
 *         Location = "Central US",
 *         ResourceGroupName = "exampleResourceGroup",
 *         Scopes = new[]
 *         {
 *             new AzureNative.Security.Inputs.AutomationScopeArgs
 *             {
 *                 Description = "A description that helps to identify this scope - for example: security assessments that relate to the resource group myResourceGroup within the subscription a5caac9c-5c04-49af-b3d0-e204f40345d5",
 *                 ScopePath = "/subscriptions/a5caac9c-5c04-49af-b3d0-e204f40345d5/resourceGroups/myResourceGroup",
 *             },
 *         },
 *         Sources = new[]
 *         {
 *             new AzureNative.Security.Inputs.AutomationSourceArgs
 *             {
 *                 EventSource = "Assessments",
 *             },
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAutomation(ctx, "automation", &security.AutomationArgs{
 * 			Actions: pulumi.Array{
 * 				security.AutomationActionLogicApp{
 * 					ActionType:         "LogicApp",
 * 					LogicAppResourceId: "/subscriptions/e54a4a18-5b94-4f90-9471-bd3decad8a2e/resourceGroups/sample/providers/Microsoft.Logic/workflows/MyTest1",
 * 					Uri:                "https://exampleTriggerUri1.com",
 * 				},
 * 			},
 * 			AutomationName:    pulumi.String("exampleAutomation"),
 * 			Description:       pulumi.String("An example of a security automation that triggers one LogicApp resource (myTest1) on any security assessment"),
 * 			IsEnabled:         pulumi.Bool(true),
 * 			Location:          pulumi.String("Central US"),
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 			Scopes: []security.AutomationScopeArgs{
 * 				{
 * 					Description: pulumi.String("A description that helps to identify this scope - for example: security assessments that relate to the resource group myResourceGroup within the subscription a5caac9c-5c04-49af-b3d0-e204f40345d5"),
 * 					ScopePath:   pulumi.String("/subscriptions/a5caac9c-5c04-49af-b3d0-e204f40345d5/resourceGroups/myResourceGroup"),
 * 				},
 * 			},
 * 			Sources: []security.AutomationSourceArgs{
 * 				{
 * 					EventSource: pulumi.String("Assessments"),
 * 				},
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Automation;
 * import com.pulumi.azurenative.security.AutomationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var automation = new Automation("automation", AutomationArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionType", "LogicApp"),
 *                 Map.entry("logicAppResourceId", "/subscriptions/e54a4a18-5b94-4f90-9471-bd3decad8a2e/resourceGroups/sample/providers/Microsoft.Logic/workflows/MyTest1"),
 *                 Map.entry("uri", "https://exampleTriggerUri1.com")
 *             ))
 *             .automationName("exampleAutomation")
 *             .description("An example of a security automation that triggers one LogicApp resource (myTest1) on any security assessment")
 *             .isEnabled(true)
 *             .location("Central US")
 *             .resourceGroupName("exampleResourceGroup")
 *             .scopes(Map.ofEntries(
 *                 Map.entry("description", "A description that helps to identify this scope - for example: security assessments that relate to the resource group myResourceGroup within the subscription a5caac9c-5c04-49af-b3d0-e204f40345d5"),
 *                 Map.entry("scopePath", "/subscriptions/a5caac9c-5c04-49af-b3d0-e204f40345d5/resourceGroups/myResourceGroup")
 *             ))
 *             .sources(Map.of("eventSource", "Assessments"))
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a security automation for all high severity assessments
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var automation = new AzureNative.Security.Automation("automation", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Security.Inputs.AutomationActionLogicAppArgs
 *             {
 *                 ActionType = "LogicApp",
 *                 LogicAppResourceId = "/subscriptions/e54a4a18-5b94-4f90-9471-bd3decad8a2e/resourceGroups/sample/providers/Microsoft.Logic/workflows/MyTest1",
 *                 Uri = "https://exampleTriggerUri1.com",
 *             },
 *         },
 *         AutomationName = "exampleAutomation",
 *         Description = "An example of a security automation that triggers one LogicApp resource (myTest1) on any high severity security assessment",
 *         IsEnabled = true,
 *         Location = "Central US",
 *         ResourceGroupName = "exampleResourceGroup",
 *         Scopes = new[]
 *         {
 *             new AzureNative.Security.Inputs.AutomationScopeArgs
 *             {
 *                 Description = "A description that helps to identify this scope - for example: security assessments that relate to the resource group myResourceGroup within the subscription a5caac9c-5c04-49af-b3d0-e204f40345d5",
 *                 ScopePath = "/subscriptions/a5caac9c-5c04-49af-b3d0-e204f40345d5/resourceGroups/myResourceGroup",
 *             },
 *         },
 *         Sources = new[]
 *         {
 *             new AzureNative.Security.Inputs.AutomationSourceArgs
 *             {
 *                 EventSource = "Assessments",
 *                 RuleSets = new[]
 *                 {
 *                     new AzureNative.Security.Inputs.AutomationRuleSetArgs
 *                     {
 *                         Rules = new[]
 *                         {
 *                             new AzureNative.Security.Inputs.AutomationTriggeringRuleArgs
 *                             {
 *                                 ExpectedValue = "High",
 *                                 Operator = "Equals",
 *                                 PropertyJPath = "properties.metadata.severity",
 *                                 PropertyType = "String",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAutomation(ctx, "automation", &security.AutomationArgs{
 * 			Actions: pulumi.Array{
 * 				security.AutomationActionLogicApp{
 * 					ActionType:         "LogicApp",
 * 					LogicAppResourceId: "/subscriptions/e54a4a18-5b94-4f90-9471-bd3decad8a2e/resourceGroups/sample/providers/Microsoft.Logic/workflows/MyTest1",
 * 					Uri:                "https://exampleTriggerUri1.com",
 * 				},
 * 			},
 * 			AutomationName:    pulumi.String("exampleAutomation"),
 * 			Description:       pulumi.String("An example of a security automation that triggers one LogicApp resource (myTest1) on any high severity security assessment"),
 * 			IsEnabled:         pulumi.Bool(true),
 * 			Location:          pulumi.String("Central US"),
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 			Scopes: []security.AutomationScopeArgs{
 * 				{
 * 					Description: pulumi.String("A description that helps to identify this scope - for example: security assessments that relate to the resource group myResourceGroup within the subscription a5caac9c-5c04-49af-b3d0-e204f40345d5"),
 * 					ScopePath:   pulumi.String("/subscriptions/a5caac9c-5c04-49af-b3d0-e204f40345d5/resourceGroups/myResourceGroup"),
 * 				},
 * 			},
 * 			Sources: []security.AutomationSourceArgs{
 * 				{
 * 					EventSource: pulumi.String("Assessments"),
 * 					RuleSets: security.AutomationRuleSetArray{
 * 						{
 * 							Rules: security.AutomationTriggeringRuleArray{
 * 								{
 * 									ExpectedValue: pulumi.String("High"),
 * 									Operator:      pulumi.String("Equals"),
 * 									PropertyJPath: pulumi.String("properties.metadata.severity"),
 * 									PropertyType:  pulumi.String("String"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Automation;
 * import com.pulumi.azurenative.security.AutomationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var automation = new Automation("automation", AutomationArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionType", "LogicApp"),
 *                 Map.entry("logicAppResourceId", "/subscriptions/e54a4a18-5b94-4f90-9471-bd3decad8a2e/resourceGroups/sample/providers/Microsoft.Logic/workflows/MyTest1"),
 *                 Map.entry("uri", "https://exampleTriggerUri1.com")
 *             ))
 *             .automationName("exampleAutomation")
 *             .description("An example of a security automation that triggers one LogicApp resource (myTest1) on any high severity security assessment")
 *             .isEnabled(true)
 *             .location("Central US")
 *             .resourceGroupName("exampleResourceGroup")
 *             .scopes(Map.ofEntries(
 *                 Map.entry("description", "A description that helps to identify this scope - for example: security assessments that relate to the resource group myResourceGroup within the subscription a5caac9c-5c04-49af-b3d0-e204f40345d5"),
 *                 Map.entry("scopePath", "/subscriptions/a5caac9c-5c04-49af-b3d0-e204f40345d5/resourceGroups/myResourceGroup")
 *             ))
 *             .sources(Map.ofEntries(
 *                 Map.entry("eventSource", "Assessments"),
 *                 Map.entry("ruleSets", Map.of("rules", Map.ofEntries(
 *                     Map.entry("expectedValue", "High"),
 *                     Map.entry("operator", "Equals"),
 *                     Map.entry("propertyJPath", "properties.metadata.severity"),
 *                     Map.entry("propertyType", "String")
 *                 )))
 *             ))
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Disable or enable a security automation
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var automation = new AzureNative.Security.Automation("automation", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Security.Inputs.AutomationActionLogicAppArgs
 *             {
 *                 ActionType = "LogicApp",
 *                 LogicAppResourceId = "/subscriptions/e54a4a18-5b94-4f90-9471-bd3decad8a2e/resourceGroups/sample/providers/Microsoft.Logic/workflows/MyTest1",
 *                 Uri = "https://exampleTriggerUri1.com",
 *             },
 *         },
 *         AutomationName = "exampleAutomation",
 *         Description = "An example of a security automation that triggers one LogicApp resource (myTest1) on any security assessment of type customAssessment",
 *         IsEnabled = false,
 *         Location = "Central US",
 *         ResourceGroupName = "exampleResourceGroup",
 *         Scopes = new[]
 *         {
 *             new AzureNative.Security.Inputs.AutomationScopeArgs
 *             {
 *                 Description = "A description that helps to identify this scope - for example: security assessments that relate to the resource group myResourceGroup within the subscription a5caac9c-5c04-49af-b3d0-e204f40345d5",
 *                 ScopePath = "/subscriptions/a5caac9c-5c04-49af-b3d0-e204f40345d5/resourceGroups/myResourceGroup",
 *             },
 *         },
 *         Sources = new[]
 *         {
 *             new AzureNative.Security.Inputs.AutomationSourceArgs
 *             {
 *                 EventSource = "Assessments",
 *                 RuleSets = new[]
 *                 {
 *                     new AzureNative.Security.Inputs.AutomationRuleSetArgs
 *                     {
 *                         Rules = new[]
 *                         {
 *                             new AzureNative.Security.Inputs.AutomationTriggeringRuleArgs
 *                             {
 *                                 ExpectedValue = "customAssessment",
 *                                 Operator = "Equals",
 *                                 PropertyJPath = "$.Entity.AssessmentType",
 *                                 PropertyType = "String",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAutomation(ctx, "automation", &security.AutomationArgs{
 * 			Actions: pulumi.Array{
 * 				security.AutomationActionLogicApp{
 * 					ActionType:         "LogicApp",
 * 					LogicAppResourceId: "/subscriptions/e54a4a18-5b94-4f90-9471-bd3decad8a2e/resourceGroups/sample/providers/Microsoft.Logic/workflows/MyTest1",
 * 					Uri:                "https://exampleTriggerUri1.com",
 * 				},
 * 			},
 * 			AutomationName:    pulumi.String("exampleAutomation"),
 * 			Description:       pulumi.String("An example of a security automation that triggers one LogicApp resource (myTest1) on any security assessment of type customAssessment"),
 * 			IsEnabled:         pulumi.Bool(false),
 * 			Location:          pulumi.String("Central US"),
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 			Scopes: []security.AutomationScopeArgs{
 * 				{
 * 					Description: pulumi.String("A description that helps to identify this scope - for example: security assessments that relate to the resource group myResourceGroup within the subscription a5caac9c-5c04-49af-b3d0-e204f40345d5"),
 * 					ScopePath:   pulumi.String("/subscriptions/a5caac9c-5c04-49af-b3d0-e204f40345d5/resourceGroups/myResourceGroup"),
 * 				},
 * 			},
 * 			Sources: []security.AutomationSourceArgs{
 * 				{
 * 					EventSource: pulumi.String("Assessments"),
 * 					RuleSets: security.AutomationRuleSetArray{
 * 						{
 * 							Rules: security.AutomationTriggeringRuleArray{
 * 								{
 * 									ExpectedValue: pulumi.String("customAssessment"),
 * 									Operator:      pulumi.String("Equals"),
 * 									PropertyJPath: pulumi.String("$.Entity.AssessmentType"),
 * 									PropertyType:  pulumi.String("String"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Automation;
 * import com.pulumi.azurenative.security.AutomationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var automation = new Automation("automation", AutomationArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionType", "LogicApp"),
 *                 Map.entry("logicAppResourceId", "/subscriptions/e54a4a18-5b94-4f90-9471-bd3decad8a2e/resourceGroups/sample/providers/Microsoft.Logic/workflows/MyTest1"),
 *                 Map.entry("uri", "https://exampleTriggerUri1.com")
 *             ))
 *             .automationName("exampleAutomation")
 *             .description("An example of a security automation that triggers one LogicApp resource (myTest1) on any security assessment of type customAssessment")
 *             .isEnabled(false)
 *             .location("Central US")
 *             .resourceGroupName("exampleResourceGroup")
 *             .scopes(Map.ofEntries(
 *                 Map.entry("description", "A description that helps to identify this scope - for example: security assessments that relate to the resource group myResourceGroup within the subscription a5caac9c-5c04-49af-b3d0-e204f40345d5"),
 *                 Map.entry("scopePath", "/subscriptions/a5caac9c-5c04-49af-b3d0-e204f40345d5/resourceGroups/myResourceGroup")
 *             ))
 *             .sources(Map.ofEntries(
 *                 Map.entry("eventSource", "Assessments"),
 *                 Map.entry("ruleSets", Map.of("rules", Map.ofEntries(
 *                     Map.entry("expectedValue", "customAssessment"),
 *                     Map.entry("operator", "Equals"),
 *                     Map.entry("propertyJPath", "$.Entity.AssessmentType"),
 *                     Map.entry("propertyType", "String")
 *                 )))
 *             ))
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:Automation exampleAutomation /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/automations/{automationName}
 * ```
 */
public class Automation internal constructor(
    override val javaResource: com.pulumi.azurenative.security.Automation,
) : KotlinCustomResource(javaResource, AutomationMapper) {
    /**
     * A collection of the actions which are triggered if all the configured rules evaluations, within at least one rule set, are true.
     */
    public val actions: Output<List<Any>>?
        get() = javaResource.actions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The security automation description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Entity tag is used for comparing two or more entities from the same requested resource.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Indicates whether the security automation is enabled.
     */
    public val isEnabled: Output<Boolean>?
        get() = javaResource.isEnabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Kind of the resource
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Location where the resource is stored
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A collection of scopes on which the security automations logic is applied. Supported scopes are the subscription itself or a resource group under that subscription. The automation will only apply on defined scopes.
     */
    public val scopes: Output<List<AutomationScopeResponse>>?
        get() = javaResource.scopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> automationScopeResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A collection of the source event types which evaluate the security automation set of rules.
     */
    public val sources: Output<List<AutomationSourceResponse>>?
        get() = javaResource.sources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> automationSourceResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A list of key value pairs that describe the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AutomationMapper : ResourceMapper<Automation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.Automation::class == javaResource::class

    override fun map(javaResource: Resource): Automation = Automation(
        javaResource as
            com.pulumi.azurenative.security.Automation,
    )
}

/**
 * @see [Automation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Automation].
 */
public suspend fun automation(name: String, block: suspend AutomationResourceBuilder.() -> Unit):
    Automation {
    val builder = AutomationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Automation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun automation(name: String): Automation {
    val builder = AutomationResourceBuilder()
    builder.name(name)
    return builder.build()
}
