@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.AutomationArgs.builder
import com.pulumi.azurenative.security.kotlin.inputs.AutomationScopeArgs
import com.pulumi.azurenative.security.kotlin.inputs.AutomationScopeArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.AutomationSourceArgs
import com.pulumi.azurenative.security.kotlin.inputs.AutomationSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The security automation resource.
 * Azure REST API version: 2019-01-01-preview. Prior API version in Azure Native 1.x: 2019-01-01-preview.
 * ## Example Usage
 * ### Create or update a security automation for all assessments (including all severities)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var automation = new AzureNative.Security.Automation("automation", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Security.Inputs.AutomationActionLogicAppArgs
 *             {
 *                 ActionType = "LogicApp",
 *                 LogicAppResourceId = "/subscriptions/e54a4a18-5b94-4f90-9471-bd3decad8a2e/resourceGroups/sample/providers/Microsoft.Logic/workflows/MyTest1",
 *                 Uri = "https://exampleTriggerUri1.com",
 *             },
 *         },
 *         AutomationName = "exampleAutomation",
 *         Description = "An example of a security automation that triggers one LogicApp resource (myTest1) on any security assessment",
 *         IsEnabled = true,
 *         Location = "Central US",
 *         ResourceGroupName = "exampleResourceGroup",
 *         Scopes = new[]
 *         {
 *             new AzureNative.Security.Inputs.AutomationScopeArgs
 *             {
 *                 Description = "A description that helps to identify this scope - for example: security assessments that relate to the resource group myResourceGroup within the subscription a5caac9c-5c04-49af-b3d0-e204f40345d5",
 *                 ScopePath = "/subscriptions/a5caac9c-5c04-49af-b3d0-e204f40345d5/resourceGroups/myResourceGroup",
 *             },
 *         },
 *         Sources = new[]
 *         {
 *             new AzureNative.Security.Inputs.AutomationSourceArgs
 *             {
 *                 EventSource = "Assessments",
 *             },
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAutomation(ctx, "automation", &security.AutomationArgs{
 * 			Actions: pulumi.Array{
 * 				security.AutomationActionLogicApp{
 * 					ActionType:         "LogicApp",
 * 					LogicAppResourceId: "/subscriptions/e54a4a18-5b94-4f90-9471-bd3decad8a2e/resourceGroups/sample/providers/Microsoft.Logic/workflows/MyTest1",
 * 					Uri:                "https://exampleTriggerUri1.com",
 * 				},
 * 			},
 * 			AutomationName:    pulumi.String("exampleAutomation"),
 * 			Description:       pulumi.String("An example of a security automation that triggers one LogicApp resource (myTest1) on any security assessment"),
 * 			IsEnabled:         pulumi.Bool(true),
 * 			Location:          pulumi.String("Central US"),
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 			Scopes: []security.AutomationScopeArgs{
 * 				{
 * 					Description: pulumi.String("A description that helps to identify this scope - for example: security assessments that relate to the resource group myResourceGroup within the subscription a5caac9c-5c04-49af-b3d0-e204f40345d5"),
 * 					ScopePath:   pulumi.String("/subscriptions/a5caac9c-5c04-49af-b3d0-e204f40345d5/resourceGroups/myResourceGroup"),
 * 				},
 * 			},
 * 			Sources: []security.AutomationSourceArgs{
 * 				{
 * 					EventSource: pulumi.String("Assessments"),
 * 				},
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Automation;
 * import com.pulumi.azurenative.security.AutomationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var automation = new Automation("automation", AutomationArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionType", "LogicApp"),
 *                 Map.entry("logicAppResourceId", "/subscriptions/e54a4a18-5b94-4f90-9471-bd3decad8a2e/resourceGroups/sample/providers/Microsoft.Logic/workflows/MyTest1"),
 *                 Map.entry("uri", "https://exampleTriggerUri1.com")
 *             ))
 *             .automationName("exampleAutomation")
 *             .description("An example of a security automation that triggers one LogicApp resource (myTest1) on any security assessment")
 *             .isEnabled(true)
 *             .location("Central US")
 *             .resourceGroupName("exampleResourceGroup")
 *             .scopes(Map.ofEntries(
 *                 Map.entry("description", "A description that helps to identify this scope - for example: security assessments that relate to the resource group myResourceGroup within the subscription a5caac9c-5c04-49af-b3d0-e204f40345d5"),
 *                 Map.entry("scopePath", "/subscriptions/a5caac9c-5c04-49af-b3d0-e204f40345d5/resourceGroups/myResourceGroup")
 *             ))
 *             .sources(Map.of("eventSource", "Assessments"))
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a security automation for all high severity assessments
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var automation = new AzureNative.Security.Automation("automation", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Security.Inputs.AutomationActionLogicAppArgs
 *             {
 *                 ActionType = "LogicApp",
 *                 LogicAppResourceId = "/subscriptions/e54a4a18-5b94-4f90-9471-bd3decad8a2e/resourceGroups/sample/providers/Microsoft.Logic/workflows/MyTest1",
 *                 Uri = "https://exampleTriggerUri1.com",
 *             },
 *         },
 *         AutomationName = "exampleAutomation",
 *         Description = "An example of a security automation that triggers one LogicApp resource (myTest1) on any high severity security assessment",
 *         IsEnabled = true,
 *         Location = "Central US",
 *         ResourceGroupName = "exampleResourceGroup",
 *         Scopes = new[]
 *         {
 *             new AzureNative.Security.Inputs.AutomationScopeArgs
 *             {
 *                 Description = "A description that helps to identify this scope - for example: security assessments that relate to the resource group myResourceGroup within the subscription a5caac9c-5c04-49af-b3d0-e204f40345d5",
 *                 ScopePath = "/subscriptions/a5caac9c-5c04-49af-b3d0-e204f40345d5/resourceGroups/myResourceGroup",
 *             },
 *         },
 *         Sources = new[]
 *         {
 *             new AzureNative.Security.Inputs.AutomationSourceArgs
 *             {
 *                 EventSource = "Assessments",
 *                 RuleSets = new[]
 *                 {
 *                     new AzureNative.Security.Inputs.AutomationRuleSetArgs
 *                     {
 *                         Rules = new[]
 *                         {
 *                             new AzureNative.Security.Inputs.AutomationTriggeringRuleArgs
 *                             {
 *                                 ExpectedValue = "High",
 *                                 Operator = "Equals",
 *                                 PropertyJPath = "properties.metadata.severity",
 *                                 PropertyType = "String",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAutomation(ctx, "automation", &security.AutomationArgs{
 * 			Actions: pulumi.Array{
 * 				security.AutomationActionLogicApp{
 * 					ActionType:         "LogicApp",
 * 					LogicAppResourceId: "/subscriptions/e54a4a18-5b94-4f90-9471-bd3decad8a2e/resourceGroups/sample/providers/Microsoft.Logic/workflows/MyTest1",
 * 					Uri:                "https://exampleTriggerUri1.com",
 * 				},
 * 			},
 * 			AutomationName:    pulumi.String("exampleAutomation"),
 * 			Description:       pulumi.String("An example of a security automation that triggers one LogicApp resource (myTest1) on any high severity security assessment"),
 * 			IsEnabled:         pulumi.Bool(true),
 * 			Location:          pulumi.String("Central US"),
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 			Scopes: []security.AutomationScopeArgs{
 * 				{
 * 					Description: pulumi.String("A description that helps to identify this scope - for example: security assessments that relate to the resource group myResourceGroup within the subscription a5caac9c-5c04-49af-b3d0-e204f40345d5"),
 * 					ScopePath:   pulumi.String("/subscriptions/a5caac9c-5c04-49af-b3d0-e204f40345d5/resourceGroups/myResourceGroup"),
 * 				},
 * 			},
 * 			Sources: []security.AutomationSourceArgs{
 * 				{
 * 					EventSource: pulumi.String("Assessments"),
 * 					RuleSets: security.AutomationRuleSetArray{
 * 						{
 * 							Rules: security.AutomationTriggeringRuleArray{
 * 								{
 * 									ExpectedValue: pulumi.String("High"),
 * 									Operator:      pulumi.String("Equals"),
 * 									PropertyJPath: pulumi.String("properties.metadata.severity"),
 * 									PropertyType:  pulumi.String("String"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Automation;
 * import com.pulumi.azurenative.security.AutomationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var automation = new Automation("automation", AutomationArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionType", "LogicApp"),
 *                 Map.entry("logicAppResourceId", "/subscriptions/e54a4a18-5b94-4f90-9471-bd3decad8a2e/resourceGroups/sample/providers/Microsoft.Logic/workflows/MyTest1"),
 *                 Map.entry("uri", "https://exampleTriggerUri1.com")
 *             ))
 *             .automationName("exampleAutomation")
 *             .description("An example of a security automation that triggers one LogicApp resource (myTest1) on any high severity security assessment")
 *             .isEnabled(true)
 *             .location("Central US")
 *             .resourceGroupName("exampleResourceGroup")
 *             .scopes(Map.ofEntries(
 *                 Map.entry("description", "A description that helps to identify this scope - for example: security assessments that relate to the resource group myResourceGroup within the subscription a5caac9c-5c04-49af-b3d0-e204f40345d5"),
 *                 Map.entry("scopePath", "/subscriptions/a5caac9c-5c04-49af-b3d0-e204f40345d5/resourceGroups/myResourceGroup")
 *             ))
 *             .sources(Map.ofEntries(
 *                 Map.entry("eventSource", "Assessments"),
 *                 Map.entry("ruleSets", Map.of("rules", Map.ofEntries(
 *                     Map.entry("expectedValue", "High"),
 *                     Map.entry("operator", "Equals"),
 *                     Map.entry("propertyJPath", "properties.metadata.severity"),
 *                     Map.entry("propertyType", "String")
 *                 )))
 *             ))
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Disable or enable a security automation
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var automation = new AzureNative.Security.Automation("automation", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Security.Inputs.AutomationActionLogicAppArgs
 *             {
 *                 ActionType = "LogicApp",
 *                 LogicAppResourceId = "/subscriptions/e54a4a18-5b94-4f90-9471-bd3decad8a2e/resourceGroups/sample/providers/Microsoft.Logic/workflows/MyTest1",
 *                 Uri = "https://exampleTriggerUri1.com",
 *             },
 *         },
 *         AutomationName = "exampleAutomation",
 *         Description = "An example of a security automation that triggers one LogicApp resource (myTest1) on any security assessment of type customAssessment",
 *         IsEnabled = false,
 *         Location = "Central US",
 *         ResourceGroupName = "exampleResourceGroup",
 *         Scopes = new[]
 *         {
 *             new AzureNative.Security.Inputs.AutomationScopeArgs
 *             {
 *                 Description = "A description that helps to identify this scope - for example: security assessments that relate to the resource group myResourceGroup within the subscription a5caac9c-5c04-49af-b3d0-e204f40345d5",
 *                 ScopePath = "/subscriptions/a5caac9c-5c04-49af-b3d0-e204f40345d5/resourceGroups/myResourceGroup",
 *             },
 *         },
 *         Sources = new[]
 *         {
 *             new AzureNative.Security.Inputs.AutomationSourceArgs
 *             {
 *                 EventSource = "Assessments",
 *                 RuleSets = new[]
 *                 {
 *                     new AzureNative.Security.Inputs.AutomationRuleSetArgs
 *                     {
 *                         Rules = new[]
 *                         {
 *                             new AzureNative.Security.Inputs.AutomationTriggeringRuleArgs
 *                             {
 *                                 ExpectedValue = "customAssessment",
 *                                 Operator = "Equals",
 *                                 PropertyJPath = "$.Entity.AssessmentType",
 *                                 PropertyType = "String",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAutomation(ctx, "automation", &security.AutomationArgs{
 * 			Actions: pulumi.Array{
 * 				security.AutomationActionLogicApp{
 * 					ActionType:         "LogicApp",
 * 					LogicAppResourceId: "/subscriptions/e54a4a18-5b94-4f90-9471-bd3decad8a2e/resourceGroups/sample/providers/Microsoft.Logic/workflows/MyTest1",
 * 					Uri:                "https://exampleTriggerUri1.com",
 * 				},
 * 			},
 * 			AutomationName:    pulumi.String("exampleAutomation"),
 * 			Description:       pulumi.String("An example of a security automation that triggers one LogicApp resource (myTest1) on any security assessment of type customAssessment"),
 * 			IsEnabled:         pulumi.Bool(false),
 * 			Location:          pulumi.String("Central US"),
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 			Scopes: []security.AutomationScopeArgs{
 * 				{
 * 					Description: pulumi.String("A description that helps to identify this scope - for example: security assessments that relate to the resource group myResourceGroup within the subscription a5caac9c-5c04-49af-b3d0-e204f40345d5"),
 * 					ScopePath:   pulumi.String("/subscriptions/a5caac9c-5c04-49af-b3d0-e204f40345d5/resourceGroups/myResourceGroup"),
 * 				},
 * 			},
 * 			Sources: []security.AutomationSourceArgs{
 * 				{
 * 					EventSource: pulumi.String("Assessments"),
 * 					RuleSets: security.AutomationRuleSetArray{
 * 						{
 * 							Rules: security.AutomationTriggeringRuleArray{
 * 								{
 * 									ExpectedValue: pulumi.String("customAssessment"),
 * 									Operator:      pulumi.String("Equals"),
 * 									PropertyJPath: pulumi.String("$.Entity.AssessmentType"),
 * 									PropertyType:  pulumi.String("String"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Automation;
 * import com.pulumi.azurenative.security.AutomationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var automation = new Automation("automation", AutomationArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionType", "LogicApp"),
 *                 Map.entry("logicAppResourceId", "/subscriptions/e54a4a18-5b94-4f90-9471-bd3decad8a2e/resourceGroups/sample/providers/Microsoft.Logic/workflows/MyTest1"),
 *                 Map.entry("uri", "https://exampleTriggerUri1.com")
 *             ))
 *             .automationName("exampleAutomation")
 *             .description("An example of a security automation that triggers one LogicApp resource (myTest1) on any security assessment of type customAssessment")
 *             .isEnabled(false)
 *             .location("Central US")
 *             .resourceGroupName("exampleResourceGroup")
 *             .scopes(Map.ofEntries(
 *                 Map.entry("description", "A description that helps to identify this scope - for example: security assessments that relate to the resource group myResourceGroup within the subscription a5caac9c-5c04-49af-b3d0-e204f40345d5"),
 *                 Map.entry("scopePath", "/subscriptions/a5caac9c-5c04-49af-b3d0-e204f40345d5/resourceGroups/myResourceGroup")
 *             ))
 *             .sources(Map.ofEntries(
 *                 Map.entry("eventSource", "Assessments"),
 *                 Map.entry("ruleSets", Map.of("rules", Map.ofEntries(
 *                     Map.entry("expectedValue", "customAssessment"),
 *                     Map.entry("operator", "Equals"),
 *                     Map.entry("propertyJPath", "$.Entity.AssessmentType"),
 *                     Map.entry("propertyType", "String")
 *                 )))
 *             ))
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:Automation exampleAutomation /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/automations/{automationName}
 * ```
 * @property actions A collection of the actions which are triggered if all the configured rules evaluations, within at least one rule set, are true.
 * @property automationName The security automation name.
 * @property description The security automation description.
 * @property isEnabled Indicates whether the security automation is enabled.
 * @property kind Kind of the resource
 * @property location Location where the resource is stored
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property scopes A collection of scopes on which the security automations logic is applied. Supported scopes are the subscription itself or a resource group under that subscription. The automation will only apply on defined scopes.
 * @property sources A collection of the source event types which evaluate the security automation set of rules.
 * @property tags A list of key value pairs that describe the resource.
 */
public data class AutomationArgs(
    public val actions: Output<List<Any>>? = null,
    public val automationName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val isEnabled: Output<Boolean>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scopes: Output<List<AutomationScopeArgs>>? = null,
    public val sources: Output<List<AutomationSourceArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.AutomationArgs> {
    override fun toJava(): com.pulumi.azurenative.security.AutomationArgs =
        com.pulumi.azurenative.security.AutomationArgs.builder()
            .actions(actions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .automationName(automationName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scopes(scopes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .sources(
                sources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AutomationArgs].
 */
@PulumiTagMarker
public class AutomationArgsBuilder internal constructor() {
    private var actions: Output<List<Any>>? = null

    private var automationName: Output<String>? = null

    private var description: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scopes: Output<List<AutomationScopeArgs>>? = null

    private var sources: Output<List<AutomationSourceArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A collection of the actions which are triggered if all the configured rules evaluations, within at least one rule set, are true.
     */
    @JvmName("aclrjljdiedhdlly")
    public suspend fun actions(`value`: Output<List<Any>>) {
        this.actions = value
    }

    @JvmName("fcnaspgoefpmovie")
    public suspend fun actions(vararg values: Output<Any>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values A collection of the actions which are triggered if all the configured rules evaluations, within at least one rule set, are true.
     */
    @JvmName("mqryhsdtdfswlquh")
    public suspend fun actions(values: List<Output<Any>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value The security automation name.
     */
    @JvmName("cqbphjwmsuqydraf")
    public suspend fun automationName(`value`: Output<String>) {
        this.automationName = value
    }

    /**
     * @param value The security automation description.
     */
    @JvmName("prwfsfljkcjdwrgk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Indicates whether the security automation is enabled.
     */
    @JvmName("vfsvxnyxjxytqpsb")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value Kind of the resource
     */
    @JvmName("whhfyxmhhaclmkfv")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Location where the resource is stored
     */
    @JvmName("pwxeahbsbxcrpnxi")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("ogpljvjaojglqpml")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value A collection of scopes on which the security automations logic is applied. Supported scopes are the subscription itself or a resource group under that subscription. The automation will only apply on defined scopes.
     */
    @JvmName("yfgdjjfvysscncqu")
    public suspend fun scopes(`value`: Output<List<AutomationScopeArgs>>) {
        this.scopes = value
    }

    @JvmName("qbhauaregobpsolo")
    public suspend fun scopes(vararg values: Output<AutomationScopeArgs>) {
        this.scopes = Output.all(values.asList())
    }

    /**
     * @param values A collection of scopes on which the security automations logic is applied. Supported scopes are the subscription itself or a resource group under that subscription. The automation will only apply on defined scopes.
     */
    @JvmName("kifigupvwiijwrqx")
    public suspend fun scopes(values: List<Output<AutomationScopeArgs>>) {
        this.scopes = Output.all(values)
    }

    /**
     * @param value A collection of the source event types which evaluate the security automation set of rules.
     */
    @JvmName("ggdpjceaktksihlg")
    public suspend fun sources(`value`: Output<List<AutomationSourceArgs>>) {
        this.sources = value
    }

    @JvmName("snqdsdghtdhscyks")
    public suspend fun sources(vararg values: Output<AutomationSourceArgs>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values A collection of the source event types which evaluate the security automation set of rules.
     */
    @JvmName("psqjixuprmcdrosq")
    public suspend fun sources(values: List<Output<AutomationSourceArgs>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value A list of key value pairs that describe the resource.
     */
    @JvmName("nlnqgbgqgcmcsprc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A collection of the actions which are triggered if all the configured rules evaluations, within at least one rule set, are true.
     */
    @JvmName("wnmcmriigsphglvr")
    public suspend fun actions(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param values A collection of the actions which are triggered if all the configured rules evaluations, within at least one rule set, are true.
     */
    @JvmName("mrfvbyuclijnaloa")
    public suspend fun actions(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value The security automation name.
     */
    @JvmName("fsfpiolfwljwpnoh")
    public suspend fun automationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationName = mapped
    }

    /**
     * @param value The security automation description.
     */
    @JvmName("qlrnyahkikmadqmq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Indicates whether the security automation is enabled.
     */
    @JvmName("mprptsrpnuqusuyy")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value Kind of the resource
     */
    @JvmName("nlwxcimljvexsuug")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Location where the resource is stored
     */
    @JvmName("smedckaiuntxivjk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("gwoqkceabqsjlgyw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value A collection of scopes on which the security automations logic is applied. Supported scopes are the subscription itself or a resource group under that subscription. The automation will only apply on defined scopes.
     */
    @JvmName("fqrxnjigepfytyse")
    public suspend fun scopes(`value`: List<AutomationScopeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param argument A collection of scopes on which the security automations logic is applied. Supported scopes are the subscription itself or a resource group under that subscription. The automation will only apply on defined scopes.
     */
    @JvmName("ypgbbumhbfncwgwd")
    public suspend fun scopes(argument: List<suspend AutomationScopeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationScopeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.scopes = mapped
    }

    /**
     * @param argument A collection of scopes on which the security automations logic is applied. Supported scopes are the subscription itself or a resource group under that subscription. The automation will only apply on defined scopes.
     */
    @JvmName("tubftkrgjekayqek")
    public suspend fun scopes(vararg argument: suspend AutomationScopeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationScopeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.scopes = mapped
    }

    /**
     * @param argument A collection of scopes on which the security automations logic is applied. Supported scopes are the subscription itself or a resource group under that subscription. The automation will only apply on defined scopes.
     */
    @JvmName("inetjmivmrghekqq")
    public suspend fun scopes(argument: suspend AutomationScopeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AutomationScopeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.scopes = mapped
    }

    /**
     * @param values A collection of scopes on which the security automations logic is applied. Supported scopes are the subscription itself or a resource group under that subscription. The automation will only apply on defined scopes.
     */
    @JvmName("higetdpaemqbqehe")
    public suspend fun scopes(vararg values: AutomationScopeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param value A collection of the source event types which evaluate the security automation set of rules.
     */
    @JvmName("qrynjddusivhtpmf")
    public suspend fun sources(`value`: List<AutomationSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param argument A collection of the source event types which evaluate the security automation set of rules.
     */
    @JvmName("mjhbaievjvwhtfhg")
    public suspend fun sources(argument: List<suspend AutomationSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument A collection of the source event types which evaluate the security automation set of rules.
     */
    @JvmName("fmjfbtafcxqagrbf")
    public suspend fun sources(vararg argument: suspend AutomationSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument A collection of the source event types which evaluate the security automation set of rules.
     */
    @JvmName("cqtklnxmetuotpjb")
    public suspend fun sources(argument: suspend AutomationSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AutomationSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param values A collection of the source event types which evaluate the security automation set of rules.
     */
    @JvmName("hsvvbsfrmtsbcshy")
    public suspend fun sources(vararg values: AutomationSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param value A list of key value pairs that describe the resource.
     */
    @JvmName("jnyxxldfnbjshuve")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A list of key value pairs that describe the resource.
     */
    @JvmName("jseiumpjmeyxxlvw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AutomationArgs = AutomationArgs(
        actions = actions,
        automationName = automationName,
        description = description,
        isEnabled = isEnabled,
        kind = kind,
        location = location,
        resourceGroupName = resourceGroupName,
        scopes = scopes,
        sources = sources,
        tags = tags,
    )
}
