@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.AzureServersSettingArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.ServerVulnerabilityAssessmentsAzureSettingSelectedProvider
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A vulnerability assessments setting on Azure servers in the defined scope.
 * Azure REST API version: 2023-05-01.
 * ## Example Usage
 * ### Set a server vulnerability assessments setting of the kind settingKind on the subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureServersSetting = new AzureNative.Security.AzureServersSetting("azureServersSetting", new()
 *     {
 *         Kind = "AzureServersSetting",
 *         SelectedProvider = "MdeTvm",
 *         SettingKind = "azureServersSetting",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAzureServersSetting(ctx, "azureServersSetting", &security.AzureServersSettingArgs{
 * 			Kind:             pulumi.String("AzureServersSetting"),
 * 			SelectedProvider: pulumi.String("MdeTvm"),
 * 			SettingKind:      pulumi.String("azureServersSetting"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.AzureServersSetting;
 * import com.pulumi.azurenative.security.AzureServersSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureServersSetting = new AzureServersSetting("azureServersSetting", AzureServersSettingArgs.builder()
 *             .kind("AzureServersSetting")
 *             .selectedProvider("MdeTvm")
 *             .settingKind("azureServersSetting")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:AzureServersSetting azureServersSetting /subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}
 * ```
 * @property kind The kind of the server vulnerability assessments setting
 * Expected value is 'AzureServersSetting'.
 * @property selectedProvider The selected vulnerability assessments provider on Azure servers in the defined scope.
 * @property settingKind The kind of the server vulnerability assessments setting
 */
public data class AzureServersSettingArgs(
    public val kind: Output<String>? = null,
    public val selectedProvider:
    Output<Either<String, ServerVulnerabilityAssessmentsAzureSettingSelectedProvider>>? = null,
    public val settingKind: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.AzureServersSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.security.AzureServersSettingArgs =
        com.pulumi.azurenative.security.AzureServersSettingArgs.builder()
            .kind(kind?.applyValue({ args0 -> args0 }))
            .selectedProvider(
                selectedProvider?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .settingKind(settingKind?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureServersSettingArgs].
 */
@PulumiTagMarker
public class AzureServersSettingArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var selectedProvider:
        Output<Either<String, ServerVulnerabilityAssessmentsAzureSettingSelectedProvider>>? = null

    private var settingKind: Output<String>? = null

    /**
     * @param value The kind of the server vulnerability assessments setting
     * Expected value is 'AzureServersSetting'.
     */
    @JvmName("yemcknhcmpywqlpo")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The selected vulnerability assessments provider on Azure servers in the defined scope.
     */
    @JvmName("mfbewqygmnnwcqqc")
    public suspend
    fun selectedProvider(`value`: Output<Either<String, ServerVulnerabilityAssessmentsAzureSettingSelectedProvider>>) {
        this.selectedProvider = value
    }

    /**
     * @param value The kind of the server vulnerability assessments setting
     */
    @JvmName("yiuwpcfysfptxkfw")
    public suspend fun settingKind(`value`: Output<String>) {
        this.settingKind = value
    }

    /**
     * @param value The kind of the server vulnerability assessments setting
     * Expected value is 'AzureServersSetting'.
     */
    @JvmName("lwadnnqdnhoyxhhi")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The selected vulnerability assessments provider on Azure servers in the defined scope.
     */
    @JvmName("kpuydchkneyqhbaj")
    public suspend
    fun selectedProvider(`value`: Either<String, ServerVulnerabilityAssessmentsAzureSettingSelectedProvider>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selectedProvider = mapped
    }

    /**
     * @param value The selected vulnerability assessments provider on Azure servers in the defined scope.
     */
    @JvmName("vhywdnctbgmmgyjp")
    public fun selectedProvider(`value`: String) {
        val toBeMapped = Either.ofLeft<String,
            ServerVulnerabilityAssessmentsAzureSettingSelectedProvider,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedProvider = mapped
    }

    /**
     * @param value The selected vulnerability assessments provider on Azure servers in the defined scope.
     */
    @JvmName("hqtfasnphbdolxtu")
    public fun selectedProvider(`value`: ServerVulnerabilityAssessmentsAzureSettingSelectedProvider) {
        val toBeMapped = Either.ofRight<String,
            ServerVulnerabilityAssessmentsAzureSettingSelectedProvider,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedProvider = mapped
    }

    /**
     * @param value The kind of the server vulnerability assessments setting
     */
    @JvmName("abxjdisccxdgoypr")
    public suspend fun settingKind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settingKind = mapped
    }

    internal fun build(): AzureServersSettingArgs = AzureServersSettingArgs(
        kind = kind,
        selectedProvider = selectedProvider,
        settingKind = settingKind,
    )
}
