@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CustomAssessmentAutomation].
 */
@PulumiTagMarker
public class CustomAssessmentAutomationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomAssessmentAutomationArgs = CustomAssessmentAutomationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomAssessmentAutomationArgsBuilder.() -> Unit) {
        val builder = CustomAssessmentAutomationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CustomAssessmentAutomation {
        val builtJavaResource =
            com.pulumi.azurenative.security.CustomAssessmentAutomation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CustomAssessmentAutomation(builtJavaResource)
    }
}

/**
 * Custom Assessment Automation
 * Azure REST API version: 2021-07-01-preview. Prior API version in Azure Native 1.x: 2021-07-01-preview.
 * ## Example Usage
 * ### Create a Custom Assessment Automation
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customAssessmentAutomation = new AzureNative.Security.CustomAssessmentAutomation("customAssessmentAutomation", new()
 *     {
 *         CompressedQuery = "DQAKAEkAYQBtAF8ARwByAG8AdQBwAA0ACgB8ACAAZQB4AHQAZQBuAGQAIABIAGUAYQBsAHQAaABTAHQAYQB0AHUAcwAgAD0AIABpAGYAZgAoAHQAbwBzAHQAcgBpAG4AZwAoAFIAZQBjAG8AcgBkAC4AVQBzAGUAcgBOAGEAbQBlACkAIABjAG8AbgB0AGEAaQBuAHMAIAAnAHUAcwBlAHIAJwAsACAAJwBVAE4ASABFAEEATABUAEgAWQAnACwAIAAnAEgARQBBAEwAVABIAFkAJwApAA0ACgA=",
 *         CustomAssessmentAutomationName = "MyCustomAssessmentAutomation",
 *         Description = "Data should be encrypted",
 *         DisplayName = "Password Policy",
 *         RemediationDescription = "Encrypt store by...",
 *         ResourceGroupName = "TestResourceGroup",
 *         Severity = "Medium",
 *         SupportedCloud = "AWS",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewCustomAssessmentAutomation(ctx, "customAssessmentAutomation", &security.CustomAssessmentAutomationArgs{
 * 			CompressedQuery:                pulumi.String("DQAKAEkAYQBtAF8ARwByAG8AdQBwAA0ACgB8ACAAZQB4AHQAZQBuAGQAIABIAGUAYQBsAHQAaABTAHQAYQB0AHUAcwAgAD0AIABpAGYAZgAoAHQAbwBzAHQAcgBpAG4AZwAoAFIAZQBjAG8AcgBkAC4AVQBzAGUAcgBOAGEAbQBlACkAIABjAG8AbgB0AGEAaQBuAHMAIAAnAHUAcwBlAHIAJwAsACAAJwBVAE4ASABFAEEATABUAEgAWQAnACwAIAAnAEgARQBBAEwAVABIAFkAJwApAA0ACgA="),
 * 			CustomAssessmentAutomationName: pulumi.String("MyCustomAssessmentAutomation"),
 * 			Description:                    pulumi.String("Data should be encrypted"),
 * 			DisplayName:                    pulumi.String("Password Policy"),
 * 			RemediationDescription:         pulumi.String("Encrypt store by..."),
 * 			ResourceGroupName:              pulumi.String("TestResourceGroup"),
 * 			Severity:                       pulumi.String("Medium"),
 * 			SupportedCloud:                 pulumi.String("AWS"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.CustomAssessmentAutomation;
 * import com.pulumi.azurenative.security.CustomAssessmentAutomationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customAssessmentAutomation = new CustomAssessmentAutomation("customAssessmentAutomation", CustomAssessmentAutomationArgs.builder()
 *             .compressedQuery("DQAKAEkAYQBtAF8ARwByAG8AdQBwAA0ACgB8ACAAZQB4AHQAZQBuAGQAIABIAGUAYQBsAHQAaABTAHQAYQB0AHUAcwAgAD0AIABpAGYAZgAoAHQAbwBzAHQAcgBpAG4AZwAoAFIAZQBjAG8AcgBkAC4AVQBzAGUAcgBOAGEAbQBlACkAIABjAG8AbgB0AGEAaQBuAHMAIAAnAHUAcwBlAHIAJwAsACAAJwBVAE4ASABFAEEATABUAEgAWQAnACwAIAAnAEgARQBBAEwAVABIAFkAJwApAA0ACgA=")
 *             .customAssessmentAutomationName("MyCustomAssessmentAutomation")
 *             .description("Data should be encrypted")
 *             .displayName("Password Policy")
 *             .remediationDescription("Encrypt store by...")
 *             .resourceGroupName("TestResourceGroup")
 *             .severity("Medium")
 *             .supportedCloud("AWS")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:CustomAssessmentAutomation 33e7cc6e-a139-4723-a0e5-76993aee0771 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Security/customAssessmentAutomations/{customAssessmentAutomationName}
 * ```
 */
public class CustomAssessmentAutomation internal constructor(
    override val javaResource: com.pulumi.azurenative.security.CustomAssessmentAutomation,
) : KotlinCustomResource(javaResource, CustomAssessmentAutomationMapper) {
    /**
     * The assessment metadata key used when an assessment is generated for this assessment automation.
     */
    public val assessmentKey: Output<String>?
        get() = javaResource.assessmentKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * GZip encoded KQL query representing the assessment automation results required.
     */
    public val compressedQuery: Output<String>?
        get() = javaResource.compressedQuery().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description to relate to the assessments generated by this assessment automation.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name of the assessments generated by this assessment automation.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The remediation description to relate to the assessments generated by this assessment automation.
     */
    public val remediationDescription: Output<String>?
        get() = javaResource.remediationDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The severity to relate to the assessments generated by this assessment automation.
     */
    public val severity: Output<String>?
        get() = javaResource.severity().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Relevant cloud for the custom assessment automation.
     */
    public val supportedCloud: Output<String>?
        get() = javaResource.supportedCloud().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CustomAssessmentAutomationMapper : ResourceMapper<CustomAssessmentAutomation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.CustomAssessmentAutomation::class == javaResource::class

    override fun map(javaResource: Resource): CustomAssessmentAutomation =
        CustomAssessmentAutomation(
            javaResource as
                com.pulumi.azurenative.security.CustomAssessmentAutomation,
        )
}

/**
 * @see [CustomAssessmentAutomation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomAssessmentAutomation].
 */
public suspend fun customAssessmentAutomation(
    name: String,
    block: suspend CustomAssessmentAutomationResourceBuilder.() -> Unit,
):
    CustomAssessmentAutomation {
    val builder = CustomAssessmentAutomationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomAssessmentAutomation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customAssessmentAutomation(name: String): CustomAssessmentAutomation {
    val builder = CustomAssessmentAutomationResourceBuilder()
    builder.name(name)
    return builder.build()
}
